/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common.executor;

import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTask;
import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTaskQueue;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapThreadPoolExecutorServiceQueue<TASK extends IOlapThreadPoolExecutorFutureTask>
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();
    private final IOlapThreadPoolExecutorFutureTaskQueue<TASK> tasks;

    public OlapThreadPoolExecutorServiceQueue(IOlapThreadPoolExecutorFutureTaskQueue<TASK> tasks) {
        this.tasks = tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freezeForSchema(Logger logger, String reqUUID, String schema) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.tasks.freezeForSchema(logger, reqUUID, schema);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unfreezeForSchema(Logger logger, String reqUUID, String schema) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.tasks.unfreezeForSchema(logger, reqUUID, schema);
            this.available.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.tasks.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean add(Runnable e) {
        if (this.offer(e)) {
            return true;
        }
        throw new IllegalStateException("Queue full");
    }

    @Override
    public void put(Runnable e) {
        this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable e) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.tasks.offer((IOlapThreadPoolExecutorFutureTask)e);
            this.available.signal();
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(e);
    }

    @Override
    public Runnable take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                TASK first;
                if ((first = this.tasks.peek()) != null) {
                    TASK task = this.tasks.poll();
                    this.onTaskProcessingStarted(task);
                    TASK TASK = task;
                    return TASK;
                }
                this.available.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Runnable poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            TASK task = this.tasks.poll();
            if (task != null) {
                this.onTaskProcessingStarted(task);
            }
            TASK TASK = task;
            return TASK;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nullable
    public Runnable peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            TASK TASK = this.tasks.peek();
            return TASK;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nullable
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while (true) {
                TASK task;
                if ((task = this.tasks.poll()) != null) {
                    this.onTaskProcessingStarted(task);
                    TASK TASK = task;
                    return TASK;
                }
                if (nanos <= 0L) {
                    Runnable runnable = null;
                    return runnable;
                }
                nanos = this.available.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            TASK first;
            int n;
            for (n = 0; n < maxElements && (first = this.tasks.peek()) != null; ++n) {
                c.add((Runnable)this.tasks.poll());
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<Runnable> iterator() {
        Runnable[] runnables;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            runnables = this.tasks.toArray_(new Runnable[0]);
        }
        finally {
            lock.unlock();
        }
        return new Itr(runnables);
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.tasks.clear();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean bl = this.tasks.remove(o);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] objectArray = this.tasks.toArray_(new Object[0]);
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            T[] TArray = this.tasks.toArray_(a);
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    public void onAfterExecute(TASK task) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            this.onTaskProcessingCompleted(task);
        }
        finally {
            lock.unlock();
        }
    }

    private void onTaskProcessingStarted(@Nullable TASK task) {
        if (task == null) {
            return;
        }
        this.tasks.onTaskProcessingStarted(task);
    }

    private void onTaskProcessingCompleted(TASK task) {
        this.tasks.onTaskProcessingCompleted(task);
    }

    static class Itr
    implements Iterator<Runnable> {
        final Runnable[] runnables;
        int pos = 0;

        public Itr(Runnable[] runnables) {
            this.runnables = runnables;
        }

        @Override
        public boolean hasNext() {
            return this.pos != this.runnables.length;
        }

        @Override
        public Runnable next() {
            return this.runnables[this.pos++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

