/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common.executor;

import crazydev.iccube.common.executor.IOlapThreadPoolExecutorFutureTaskQueue;
import crazydev.iccube.common.executor.OlapThreadPoolContextFutureTask;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorService;
import crazydev.iccube.common.executor.OlapThreadPoolExecutorTaskSchedulingPolicy;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapThreadPoolExecutorOrderedFutureTaskQueue
extends AbstractQueue<OlapThreadPoolContextFutureTask>
implements IOlapThreadPoolExecutorFutureTaskQueue<OlapThreadPoolContextFutureTask> {
    private final LinkedList<Queue> queues = new LinkedList();
    private final Queue noneQueue = new Queue(OlapThreadPoolExecutorTaskSchedulingPolicy.NONE);

    public OlapThreadPoolExecutorOrderedFutureTaskQueue() {
        this.queues.addLast(this.noneQueue);
    }

    @Override
    public void freezeForSchema(Logger logger, String reqUUID, String schema) {
    }

    @Override
    public void unfreezeForSchema(Logger logger, String reqUUID, String schema) {
    }

    @Override
    public void onTaskProcessingStarted(OlapThreadPoolContextFutureTask task) {
        OlapThreadPoolExecutorService.ExecutingContext context = task.getExecutingContext();
        OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy = context.getSchedulingPolicy();
        Queue toMove = null;
        if (schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER || schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION) {
            for (Queue queue : this.queues) {
                if (queue.context != context) continue;
                toMove = queue;
                break;
            }
            if (toMove == null) {
                throw new RuntimeException("internal error : inconsistent available queue usage");
            }
        } else if (schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.NONE) {
            toMove = this.noneQueue;
        } else {
            throw new RuntimeException("internal error : unexpected scheduling policy [" + schedulingPolicy.name() + "]");
        }
        if (toMove != null && this.queues.size() > 1 && this.queues.remove(toMove)) {
            this.queues.addLast(toMove);
        }
    }

    @Override
    public void onTaskProcessingCompleted(OlapThreadPoolContextFutureTask task) {
        OlapThreadPoolExecutorService.ExecutingContext context = task.getExecutingContext();
        OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy = context.getSchedulingPolicy();
        if (schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER || schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION) {
            Queue toCleanup = null;
            for (Queue queue : this.queues) {
                if (queue.context != context) continue;
                --queue.activeTaskCount;
                toCleanup = queue;
                break;
            }
            if (toCleanup == null) {
                throw new RuntimeException("internal error : inconsistent available queue usage");
            }
            this.cleanup(toCleanup);
        } else if (schedulingPolicy != OlapThreadPoolExecutorTaskSchedulingPolicy.NONE) {
            throw new RuntimeException("internal error : unexpected scheduling policy [" + schedulingPolicy.name() + "]");
        }
    }

    @Override
    public void clear() {
        ArrayList<Queue> copy = new ArrayList<Queue>(this.queues);
        for (Queue queue : copy) {
            queue.tasks.clear();
            this.cleanup(queue);
        }
    }

    private void cleanup(Queue toCleanup) {
        if (toCleanup.schedulingPolicy != OlapThreadPoolExecutorTaskSchedulingPolicy.NONE && toCleanup.activeTaskCount <= 0 && toCleanup.tasks.isEmpty()) {
            this.queues.remove(toCleanup);
        }
    }

    @Override
    public int size() {
        int size = 0;
        for (Queue queue : this.queues) {
            size += queue.tasks.size();
        }
        return size;
    }

    @Override
    public boolean offer(OlapThreadPoolContextFutureTask task) {
        OlapThreadPoolExecutorService.ExecutingContext context = task.getExecutingContext();
        OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy = context.getSchedulingPolicy();
        if (schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.NONE) {
            return this.offerNoneTask(task);
        }
        if (schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER || schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION) {
            return this.offerOtherTask(context, task);
        }
        throw new RuntimeException("internal error : unexpected scheduling policy [" + schedulingPolicy.name() + "]");
    }

    private boolean offerNoneTask(OlapThreadPoolContextFutureTask task) {
        this.noneQueue.tasks.offer(task);
        return true;
    }

    private boolean offerOtherTask(OlapThreadPoolExecutorService.ExecutingContext context, OlapThreadPoolContextFutureTask task) {
        for (Queue availableQueue : this.queues) {
            if (availableQueue.context != context) continue;
            availableQueue.tasks.offer(task);
            return true;
        }
        Queue queue = new Queue(context);
        queue.tasks.offer(task);
        this.queues.addFirst(queue);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = false;
        Queue toCleanup = null;
        for (Queue queue : this.queues) {
            if (!queue.tasks.remove(o)) continue;
            toCleanup = queue;
            removed = true;
            break;
        }
        if (toCleanup != null) {
            this.cleanup(toCleanup);
        }
        return removed;
    }

    @Override
    @Nullable
    public OlapThreadPoolContextFutureTask peek() {
        OlapThreadPoolContextFutureTask t;
        for (Queue queue : this.queues) {
            if (queue.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION && queue.activeTaskCount > 0 || (t = queue.peek()) == null) continue;
            return t;
        }
        for (Queue queue : this.queues) {
            t = queue.peek();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    @Nullable
    public OlapThreadPoolContextFutureTask poll() {
        OlapThreadPoolContextFutureTask t;
        for (Queue queue : this.queues) {
            if (queue.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION && queue.activeTaskCount > 0 || (t = queue.poll()) == null) continue;
            return t;
        }
        for (Queue queue : this.queues) {
            t = queue.poll();
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public Iterator<OlapThreadPoolContextFutureTask> iterator() {
        throw new RuntimeException("internal error: task queue inconsistent usage (iterator)");
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new RuntimeException("internal error: task queue inconsistent usage (toArray)");
    }

    @Override
    public <T> T[] toArray_(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int pos = 0;
        for (Queue availableQueue : this.queues) {
            for (OlapThreadPoolContextFutureTask task : availableQueue.tasks) {
                a[pos++] = task;
            }
        }
        return a;
    }

    @Override
    public String toString() {
        return "...";
    }

    static class Queue {
        final OlapThreadPoolExecutorService.ExecutingContext context;
        final OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy;
        final LinkedList<OlapThreadPoolContextFutureTask> tasks = new LinkedList();
        int activeTaskCount;

        Queue(OlapThreadPoolExecutorTaskSchedulingPolicy schedulingPolicy) {
            this.context = null;
            this.schedulingPolicy = schedulingPolicy;
        }

        Queue(OlapThreadPoolExecutorService.ExecutingContext context) {
            this.context = context;
            this.schedulingPolicy = context.getSchedulingPolicy();
        }

        @Nullable
        OlapThreadPoolContextFutureTask peek() {
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.NONE) {
                return this.tasks.peek();
            }
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER) {
                if (this.activeTaskCount <= 0) {
                    return this.tasks.peek();
                }
                return null;
            }
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION) {
                return this.tasks.peek();
            }
            throw new RuntimeException("internal error : unexpected scheduling policy [" + this.schedulingPolicy.name() + "]");
        }

        @Nullable
        OlapThreadPoolContextFutureTask poll() {
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.NONE) {
                return this.tasks.poll();
            }
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.POST_ORDER) {
                if (this.activeTaskCount <= 0) {
                    OlapThreadPoolContextFutureTask t = this.tasks.poll();
                    if (t != null) {
                        ++this.activeTaskCount;
                    }
                    return t;
                }
                return null;
            }
            if (this.schedulingPolicy == OlapThreadPoolExecutorTaskSchedulingPolicy.PARTITION) {
                OlapThreadPoolContextFutureTask t = this.tasks.poll();
                if (t != null) {
                    ++this.activeTaskCount;
                }
                return t;
            }
            throw new RuntimeException("internal error : unexpected scheduling policy [" + this.schedulingPolicy.name() + "]");
        }
    }
}

