/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdPackedBitList;
import crazydev.iccube.cluster.node.backup.N_BackupContext;
import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import crazydev.iccube.cluster.shared.backup.S_BackupOutputStream;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.common.CdIntIntMapReader;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.io.IOException;
import java.util.function.IntBinaryOperator;
import java.util.function.IntPredicate;
import org.apache.commons.lang3.mutable.MutableInt;

public interface CdCompressedIntIntMap
extends CdIntIntMapReader {
    public static final CdCompressedIntIntMap EMPTY = new MapIntInt(-1, 0, 0);
    public static final int BACKUP_TYPE_BIT_LIST = -101;
    public static final int BACKUP_TYPE_MAP = -102;

    public int getBackupType();

    @Override
    public long sizeOf();

    public int getMaxIndex();

    @Override
    public int getValue(int var1);

    public int nonNullSize();

    public void save(N_BackupContext var1, S_BackupOutputStream var2) throws IOException;

    public static CdCompressedIntIntMap restore(N_RestoreContext context, S_BackupInputStream in, S_SchemaDef schemaDef, int hierarchyIdx) throws IOException {
        int backupType = in.readInt();
        return switch (backupType) {
            case -101 -> BitList.restore(context, in, hierarchyIdx);
            case -102 -> MapIntInt.restore(context, in, hierarchyIdx);
            default -> throw new IOException("unexpected list type [" + backupType + "]");
        };
    }

    public static CdIntIntMapReader compress(MapIntInt mapping) {
        mapping.trim();
        if (mapping.isEmpty()) {
            return mapping;
        }
        MutableInt minKey = new MutableInt(Integer.MAX_VALUE);
        MutableInt maxKey = new MutableInt(Integer.MIN_VALUE);
        MutableInt minPos = new MutableInt(Integer.MAX_VALUE);
        MutableInt maxPos = new MutableInt(Integer.MIN_VALUE);
        mapping.forEach((k, v) -> {
            minKey.setValue(Math.min(minKey.intValue(), k));
            maxKey.setValue(Math.max(maxKey.intValue(), k));
            minPos.setValue(Math.min(minPos.intValue(), v));
            maxPos.setValue(Math.max(maxPos.intValue(), v));
        });
        int minKeyV = minKey.intValue();
        int size = maxKey.intValue() - minKey.intValue() + 1;
        int minPosV = size == mapping.size() ? minPos.intValue() : 0;
        long bitListSize = BitList.estimatedSizeBytes((int)size, (int)minPosV, (int)maxPos.intValue());
        long mapSize = mapping.sizeOf();
        if (mapSize < bitListSize) {
            return mapping;
        }
        BitList list = new BitList(-1, size, maxPos.intValue(), minPosV, minKeyV);
        mapping.forEach((k, v) -> list.set(k - minKeyV, (int)v));
        return list;
    }

    public static CdCompressedIntIntMap build(int hierarchyIdx, int[] values, int indexAt0) {
        long setSize;
        int minPos = Integer.MAX_VALUE;
        int maxPos = Integer.MIN_VALUE;
        int startinPosMaxIdx = -1;
        int count = 0;
        for (int mm = 0; mm < values.length; ++mm) {
            int sPos = values[mm];
            minPos = Math.min(sPos, minPos);
            maxPos = Math.max(sPos, maxPos);
            if (sPos == 0) continue;
            startinPosMaxIdx = Math.max(mm, startinPosMaxIdx);
            ++count;
        }
        long bitListSize = BitList.estimatedSizeBytes((int)(startinPosMaxIdx + 1), (int)minPos, (int)maxPos);
        if (bitListSize < (setSize = (long)count * 10L)) {
            return BitList.build(hierarchyIdx, values, indexAt0, startinPosMaxIdx, maxPos, minPos);
        }
        return MapIntInt.build(hierarchyIdx, values, indexAt0, maxPos);
    }

    public void forEachNotZeroValue(IntPredicate var1);

    public int getMinIndex();

    public static class BitList
    extends CdPackedBitList
    implements CdCompressedIntIntMap {
        private static final long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)new BitList(0, 1, 0, 0, 0));
        private final int memberIndexAt0;

        public BitList(int hierarchyIdx, int count, int maxPos, int minPos, int memberIndexAt0) {
            super(count, minPos, maxPos);
            this.memberIndexAt0 = memberIndexAt0;
        }

        BitList(int hierarchyIdx, int minValue, int memberIndexAt0, long[] data, int bitWidth, int size) {
            super(data, minValue, bitWidth, size);
            this.memberIndexAt0 = memberIndexAt0;
        }

        @Override
        public long sizeOf() {
            return SHALLOW_SIZE_OF + CdRamUsageEstimator.sizeOf((long[])this.data);
        }

        @Override
        public int getBackupType() {
            return -101;
        }

        @Override
        public int nonNullSize() {
            int count = 0;
            int max = this.getMaxIndex();
            for (int mm = this.memberIndexAt0; mm <= max; ++mm) {
                int pos = this.getValue(mm);
                if (pos == 0) continue;
                ++count;
            }
            return count;
        }

        @Override
        public int getMaxIndex() {
            return this.memberIndexAt0 + this.size();
        }

        @Override
        public int getValue(int idx) {
            if (idx < this.memberIndexAt0 || idx - this.memberIndexAt0 >= super.size()) {
                return 0;
            }
            return super.getInt(idx - this.memberIndexAt0);
        }

        @Override
        public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
            out.writeInt(this.getBackupType());
            out.writeInt(this.memberIndexAt0);
            out.writeInt(this.data.length);
            out.writeLongs(this.data);
            out.writeInt(this.minValue);
            out.writeInt(this.bitWidth);
            out.writeInt(this.size);
        }

        @Override
        public void forEachNotZeroValue(IntPredicate action) {
            int max = this.getMaxIndex();
            for (int mm = this.memberIndexAt0; mm <= max; ++mm) {
                int pos = this.getValue(mm);
                if (pos == 0) continue;
                action.test(mm);
            }
        }

        @Override
        public int getMinIndex() {
            return this.memberIndexAt0;
        }

        public void forEachNotZeroKeyValue(IntBinaryOperator action) {
            int max = this.getMaxIndex();
            for (int mm = this.memberIndexAt0; mm <= max; ++mm) {
                int pos = this.getValue(mm);
                if (pos == 0) continue;
                action.applyAsInt(mm, pos);
            }
        }

        static BitList restore(N_RestoreContext context, S_BackupInputStream in, int hierarchyIdx) throws IOException {
            int memberIndexAt0 = in.readInt();
            long[] data = new long[in.readInt()];
            in.readLongs(data);
            int minValue = in.readInt();
            int bitWidth = in.readInt();
            int size = in.readInt();
            return new BitList(hierarchyIdx, minValue, memberIndexAt0, data, bitWidth, size);
        }

        public static BitList build(int hierarchyIdx, int[] startingPos, int memberIndexAt0, int maxArraySize, int maxPos, int minPos) {
            BitList positions = new BitList(hierarchyIdx, maxArraySize + 1, maxPos, minPos, memberIndexAt0);
            for (int mm = 0; mm <= maxArraySize; ++mm) {
                int sPos = startingPos[mm];
                if (minPos == 0 && sPos == 0) continue;
                positions.set(mm, sPos);
            }
            return positions;
        }
    }

    public static class MapIntInt
    extends Int2IntOpenHashMap
    implements CdCompressedIntIntMap {
        private static long SHALLOW_SIZE_OF = -1L;
        private final int memberIndexAt0;
        private final int maxMemberIdx;

        public MapIntInt() {
            this.memberIndexAt0 = 0;
            this.maxMemberIdx = 0;
        }

        public MapIntInt(int hierarchyIdx, int memberIndexAt0, int maxMemberIdx) {
            this.memberIndexAt0 = memberIndexAt0;
            this.maxMemberIdx = maxMemberIdx;
        }

        public boolean trim() {
            boolean ret = super.trim();
            this.entries = null;
            this.keys = null;
            this.values = null;
            return ret;
        }

        @Override
        public int getBackupType() {
            return -102;
        }

        @Override
        public long sizeOf() {
            long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf((Object)this));
            return size + CdRamUsageEstimator.sizeOf((int[])this.key) + CdRamUsageEstimator.sizeOf((int[])this.value) + CdRamUsageEstimator.shallowSizeOf((Object)this.entries) + CdRamUsageEstimator.shallowSizeOf((Object)this.keys) + CdRamUsageEstimator.shallowSizeOf((Object)this.values);
        }

        @Override
        public int nonNullSize() {
            return this.size();
        }

        @Override
        public int getMaxIndex() {
            return this.maxMemberIdx;
        }

        @Override
        public int getValue(int idx) {
            return this.get(idx);
        }

        @Override
        public void save(N_BackupContext context, S_BackupOutputStream out) throws IOException {
            out.writeInt(this.getBackupType());
            out.writeInt(this.memberIndexAt0);
            out.writeInt(this.maxMemberIdx);
            out.writeInt(this.size());
            this.forEach((key, value) -> {
                try {
                    out.writeInt((int)key);
                    out.writeInt((int)value);
                }
                catch (IOException ex) {
                    throw new RuntimeException("IO error while creating the backup", ex);
                }
            });
        }

        @Override
        public void forEachNotZeroValue(IntPredicate action) {
            this.keySet().forEach(action::test);
        }

        @Override
        public int getMinIndex() {
            return this.memberIndexAt0;
        }

        static MapIntInt restore(N_RestoreContext context, S_BackupInputStream in, int hierarchyIdx) throws IOException {
            int memberIndexAt0 = in.readInt();
            int maxMemberIdx = in.readInt();
            MapIntInt positions = new MapIntInt(hierarchyIdx, memberIndexAt0, maxMemberIdx);
            int size = in.readInt();
            for (int mm = 0; mm < size; ++mm) {
                positions.put(in.readInt(), in.readInt());
            }
            return positions;
        }

        public static MapIntInt build(int hierarchyIdx, int[] startingPos, int memberIndexAt0, int maxMemberIdx) {
            MapIntInt positions = new MapIntInt(hierarchyIdx, memberIndexAt0, maxMemberIdx);
            for (int mm = 0; mm < startingPos.length; ++mm) {
                int sPos = startingPos[mm];
                if (sPos == 0) continue;
                positions.put(mm + memberIndexAt0, sPos);
            }
            positions.trim();
            return positions;
        }
    }
}

