/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.collection.CdArrayList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.collection.olapiterator.OlapFilterIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualAsyncIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualParallelIteratorNG;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualSingleItemIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoAutoExistBuilder;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoReducer;
import crazydev.iccube.collection.olapiterator.fastcj.CjIteratorTupleCompleter;
import crazydev.iccube.collection.olapiterator.fastcj.ICjIteratorTupleCompleter;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapAll4FactMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityFactory;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapFastCrossjoinIterator
extends OlapBaseIterator<OlapTuple> {
    public static final Logger LOGGER = OlapLoggers.MDX_EVALUATION_FAST_CROSSJOIN;
    private static final int STATE_START = 0;
    private static final int STATE_NEXT = 1;
    private static final int STATE_NEXT_RESET = 2;
    @Nullable
    public static Boolean TEST_CJ_ASYNC_ACTIVATED = null;
    @Nullable
    public static Boolean TEST_CJ_PARALLEL_ACTIVATED = null;
    private final boolean asyncActivated;
    private final boolean parallelActivated;
    private final OlapFastCrossjoinContext context;
    private final OlapTupleDimensionalityCache cache;
    private final List<OlapIterator<? extends OlapTuple>> originalIterators;
    private final boolean allowsMultipleIteration;
    private int state;
    private OlapTupleDimensionality tupleDimensionality;
    private CjFastActualBaseIterator actualIterator;
    private boolean isEmpty;
    private long memberCount;
    private long start;
    private String infoSize;
    private int itemLimit = -1;
    private Set<Integer> isIteratorMembersOfAll;

    public OlapFastCrossjoinIterator(OlapFastCrossjoinContext context, List<? extends OlapIterable<? extends OlapTuple>> originalSets, @Nullable OlapTupleFilter filter) {
        this.context = context;
        this.cache = context.getTupleDimensionalityCache();
        this.originalIterators = new ArrayList<OlapIterator<? extends OlapTuple>>();
        originalSets.forEach(t -> this.addAllIterators(this.originalIterators, (OlapIterable<? extends OlapTuple>)t, filter));
        this.allowsMultipleIteration = !context.isForTidyEvaluation();
        this.state = 0;
        this.asyncActivated = TEST_CJ_ASYNC_ACTIVATED == null ? context.isNeCjAsyncActivated() : TEST_CJ_ASYNC_ACTIVATED.booleanValue();
        this.parallelActivated = TEST_CJ_PARALLEL_ACTIVATED == null ? context.isNeCjParallelActivated() : TEST_CJ_PARALLEL_ACTIVATED.booleanValue();
    }

    public OlapFastCrossjoinIterator(OlapFastCrossjoinContext context, List<OlapIterator<? extends OlapTuple>> originalIterators, int itemLimit) {
        this.context = context;
        this.cache = context.getTupleDimensionalityCache();
        this.originalIterators = new ArrayList<OlapIterator<? extends OlapTuple>>(originalIterators.size());
        this.itemLimit = itemLimit;
        originalIterators.forEach(t -> this.originalIterators.add(t.newInstance()));
        this.allowsMultipleIteration = !context.isForTidyEvaluation();
        this.state = 0;
        this.asyncActivated = TEST_CJ_ASYNC_ACTIVATED == null ? context.isNeCjAsyncActivated() : TEST_CJ_ASYNC_ACTIVATED.booleanValue();
        this.parallelActivated = TEST_CJ_PARALLEL_ACTIVATED == null ? context.isNeCjParallelActivated() : TEST_CJ_PARALLEL_ACTIVATED.booleanValue();
    }

    @Override
    public boolean isCrossjoin() {
        return true;
    }

    @Nullable
    public OlapFastCrossjoinIterator fastCrossjoinForNonEmptyProcessing(OlapFastCrossjoinContext crossjoinContext) {
        List<OlapIterator<? extends OlapTuple>> iterators = this.originalIterators.stream().map(iter -> {
            OlapIterator iter2 = iter.fastCrossjoinForNonEmptyProcessing(crossjoinContext);
            return iter2 == null ? iter : iter2;
        }).toList();
        return new OlapFastCrossjoinIterator(crossjoinContext, iterators, this.itemLimit);
    }

    public boolean isDimensionalityOk() {
        for (int i = 0; i < this.originalIterators.size(); ++i) {
            OlapIterator<? extends OlapTuple> it1 = this.originalIterators.get(i);
            OlapTupleDimensionality dim1 = it1.getTupleDimensionality();
            if (dim1 == null) continue;
            for (int j = 0; j < i; ++j) {
                OlapIterator<? extends OlapTuple> it2 = this.originalIterators.get(j);
                OlapTupleDimensionality dim2 = it2.getTupleDimensionality();
                if (dim2 == null || !dim1.intersects(dim2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public OlapIterator<OlapTuple> head(int count) {
        OlapFastCrossjoinIterator another = this.newInstance();
        another.itemLimit = count;
        return another;
    }

    public OlapFastCrossjoinIterator newInstance() {
        OlapFastCrossjoinContext cContext = this.context.newInstanceForCrossjoinIterator();
        return new OlapFastCrossjoinIterator(cContext, this.originalIterators, this.itemLimit);
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (OlapIterator<? extends OlapTuple> iterator : this.originalIterators) {
            if (!iterator.mightHaveCalcMember()) continue;
            return true;
        }
        return false;
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        if (this.isEmpty) {
            return null;
        }
        if (this.tupleDimensionality == null) {
            OlapTupleDimensionality dim = null;
            for (OlapIterator<? extends OlapTuple> iterator : this.originalIterators) {
                OlapTupleDimensionality dim2 = iterator.getTupleDimensionality();
                dim = OlapTupleDimensionalityFactory.createUnionEx(this.cache, dim, dim2);
            }
            return dim;
        }
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        if (this.isEmpty) {
            return 0L;
        }
        if (this.itemLimit != -1) {
            return this.itemLimit;
        }
        long size = 1L;
        for (OlapIterator<? extends OlapTuple> iterator : this.originalIterators) {
            long iSize = iterator.fastEstimatedSize();
            if (iSize == -1L) {
                return -1L;
            }
            size *= iSize;
        }
        return size;
    }

    @Override
    @Nullable
    public List<OlapMember> tryExtractMeasures(OlapHierarchy measureHierarchy) {
        for (OlapIterator<? extends OlapTuple> iterator : this.originalIterators) {
            OlapTupleDimensionality dimensionality = iterator.getTupleDimensionality();
            if (dimensionality == null || !dimensionality.intersects(measureHierarchy.getTupleDimensionality())) continue;
            List<OlapMember> measures = iterator.tryExtractMeasures(measureHierarchy);
            return measures;
        }
        return null;
    }

    @Override
    public boolean isMembersCrossjoin() {
        for (OlapIterator<? extends OlapTuple> iterator : this.originalIterators) {
            OlapTupleDimensionality tupleDimensionality = iterator.getTupleDimensionality();
            if (tupleDimensionality == null || tupleDimensionality.cardinality() <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public OlapBaseIterator<OlapTuple> decorateMemberCrossjoin(Function<OlapIterator<OlapMember>, OlapIterator<OlapMember>> t) {
        List<OlapIterator<? extends OlapTuple>> iterators = this.originalIterators.stream().map(i -> (OlapIterator)t.apply((OlapIterator<OlapMember>)i)).collect(Collectors.toUnmodifiableList());
        return new OlapFastCrossjoinIterator(this.context, iterators, this.itemLimit);
    }

    @Override
    public void reset() {
        this.start = System.currentTimeMillis();
        this.memberCount = 0L;
        if (this.actualIterator != null) {
            this.actualIterator.reset();
        }
        if (!this.allowsMultipleIteration) {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 2;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException("internal error: unexpected state [" + this.state + "]");
                }
            }
        }
    }

    @Override
    @Nullable
    protected OlapTuple safeNext() {
        OlapTuple next;
        if (!this.allowsMultipleIteration && this.isInitIfNeededCondition()) {
            this.assertNoMultipleIteration();
        }
        this.initIfNeeded();
        if (this.isEmpty || this.actualIterator.isEmpty() || this.itemLimit != -1 && this.memberCount >= (long)this.itemLimit) {
            return null;
        }
        if (!this.allowsMultipleIteration) {
            this.assertNoMultipleIteration();
        }
        if ((next = this.actualIterator.next()) == null) {
            this.log();
        } else if (++this.memberCount % 1000L == 0L && this.context.isCancelling()) {
            return null;
        }
        return next;
    }

    private boolean isInitIfNeededCondition() {
        return this.actualIterator == null && !this.isEmpty;
    }

    private void initIfNeeded() {
        if (this.isInitIfNeededCondition()) {
            LOGGER.debug((Object)"[fast-crossjoin] started");
            ArrayList<List<OlapTuple>> setAsList = new ArrayList<List<OlapTuple>>();
            int limit = this.context.getInternalTupleListCountCJ();
            for (OlapIterator<? extends OlapTuple> iter : this.originalIterators) {
                OlapTuple tuple;
                if (iter instanceof OlapFastCrossjoinIterator) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                int initialCapacity = (int)Math.min(262144L, iter.fastEstimatedSize());
                ArrayList<OlapTuple> tupleList = initialCapacity <= 0 ? new ArrayList<OlapTuple>() : new ArrayList(initialCapacity);
                int count = 0;
                iter.reset();
                while ((tuple = iter.next()) != null) {
                    if ((count++ & 0x3FF) == 0 && this.context.isCancelling()) {
                        throw new OlapMdxEvaluationCancelled();
                    }
                    tupleList.add(tuple);
                    if (count < limit) continue;
                    throw new OlapEvaluationException(this.context.getErrorContext(), OlapErrorCode.TUPLE_LIST_COUNT, new Serializable[]{"fast-crossjoin", Integer.valueOf(limit)});
                }
                if (!tupleList.isEmpty()) {
                    setAsList.add(tupleList);
                    continue;
                }
                this.isEmpty = true;
                LOGGER.debug((Object)"[fast-crossjoin] got empty set");
                return;
            }
            this.isIteratorMembersOfAll = IntStream.range(0, this.originalIterators.size()).boxed().filter(i -> this.originalIterators.get((int)i).isLevelMembers()).collect(Collectors.toSet());
            this.infoSize = setAsList.stream().map(tuples -> String.valueOf(tuples.size())).collect(Collectors.joining(" x ", " (", ")"));
            this.infoSize = this.infoSize + " : tuples count = " + CdStringUtils.formatNice((long)setAsList.stream().map(List::size).reduce(0, Integer::sum).intValue());
            LOGGER.debug((Object)("[fast-crossjoin] sets materialized" + this.infoSize));
            this.setupFastIterators(setAsList);
            OlapInstrExecListener listener = this.context.getInstrExecListener();
            if (listener != null) {
                listener.onFastCrossjoinNonEmptyBehavior(this.context.logNonEmptyBehavior());
            }
            LOGGER.debug((Object)("[fast-crossjoin] non-empty behavior : " + this.context.logNonEmptyBehavior()));
            LOGGER.debug((Object)"[fast-crossjoin] setup finished ");
        }
    }

    private void assertNoMultipleIteration() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new RuntimeException("internal error: unexpected fast-crossjoin multiple iterations");
            }
            default: {
                throw new IllegalStateException("internal error: unexpected state [" + this.state + "]");
            }
        }
    }

    private void log() {
        long duration = System.currentTimeMillis() - this.start;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("[fast-crossjoin] completed in " + CdTimeUtils.formatMillis((long)duration)));
            this.actualIterator.logInfo(LOGGER, this.infoSize);
            this.context.logOnCompleted(LOGGER);
        }
    }

    private void addAllIterators(List<OlapIterator<? extends OlapTuple>> iterators, OlapIterable<? extends OlapTuple> t, @Nullable OlapTupleFilter filter) {
        if (t.isNeutralElement()) {
            return;
        }
        OlapIterator<? extends OlapTuple> iter = t.getIterator(false);
        if (iter instanceof OlapFastCrossjoinIterator) {
            OlapFastCrossjoinIterator iterator = (OlapFastCrossjoinIterator)iter;
            this.originalIterators.addAll(iterator.originalIterators);
        } else if (filter != null && iter instanceof OlapFilterIterator) {
            OlapIterator olapIterator;
            OlapFilterIterator filterIterator = (OlapFilterIterator)iter;
            if (filterIterator.getFilter().sameFilter(filter) && (olapIterator = filterIterator.getUnderlyingIterator()) instanceof OlapFastCrossjoinIterator) {
                OlapFastCrossjoinIterator crossjoinIterator = (OlapFastCrossjoinIterator)olapIterator;
                this.originalIterators.addAll(crossjoinIterator.originalIterators);
            } else {
                iterators.add(iter);
            }
        } else {
            iterators.add(iter);
        }
    }

    private void setupFastIterators(List<List<OlapTuple>> setAsList) {
        LOGGER.debug((Object)"[fast-crossjoin] create reducers");
        List<CjFastTwoReducer> reducers = this.doSetupFastIterators(setAsList);
        if (reducers != null) {
            reducers.forEach(CjFastTwoReducer::performInit);
            if (this.parallelActivated && this.context.hasNonEmpty() && this.context.acquireParallelExecutor()) {
                try {
                    LOGGER.debug((Object)"[fast-crossjoin] create parallel iterator for non-empty processing");
                    this.actualIterator = new CjFastActualParallelIteratorNG(this.context, (CjFastActualIterator)this.actualIterator, this.itemLimit);
                }
                finally {
                    this.context.releaseParallelExecutor();
                }
            } else if (this.asyncActivated && this.context.hasNonEmpty()) {
                LOGGER.debug((Object)"[fast-crossjoin] create async. iterator for non-empty processing");
                this.actualIterator = new CjFastActualAsyncIterator(this.context, (CjFastActualIterator)this.actualIterator, this.itemLimit);
            }
        }
        if (!this.isEmpty) {
            this.actualIterator.reset();
        }
    }

    @Nullable
    private List<CjFastTwoReducer> doSetupFastIterators(List<List<OlapTuple>> setAsList) {
        LOGGER.debug((Object)"[fast-crossjoin] setup started");
        if (this.context.isNonEmptyZero()) {
            this.isEmpty = true;
            return null;
        }
        OlapTupleDimensionality partialDimensionality = null;
        for (int i = 0; i < setAsList.size(); ++i) {
            if (setAsList.isEmpty()) {
                this.isEmpty = true;
                return null;
            }
            partialDimensionality = OlapTupleDimensionalityFactory.createUnionEx(this.cache, partialDimensionality, setAsList.get(i).get(0).getTupleDimensionality());
        }
        this.tupleDimensionality = partialDimensionality;
        CdArrayList iteratorList = new CdArrayList(setAsList.size());
        IntStream.range(0, setAsList.size()).forEach(arg_0 -> this.lambda$doSetupFastIterators$0((ArrayList)iteratorList, setAsList, arg_0));
        LOGGER.debug((Object)"[fast-crossjoin] iterators created");
        List<ICjIteratorTupleCompleter> completers = this.shrinkAttributesToOneList((ArrayList<CjFastListBaseIterator>)iteratorList);
        if (!completers.isEmpty()) {
            LOGGER.debug((Object)("[fast-crossjoin] shrink to one : " + completers.stream().map(ICjIteratorTupleCompleter::log).collect(Collectors.joining(", "))));
        }
        int posIntTuple = 0;
        for (int i = 0; i < iteratorList.size(); ++i) {
            CjFastListBaseIterator iter = (CjFastListBaseIterator)iteratorList.get(i);
            OlapDimensionality iterDimensionality = this.context.toDimensionality(iter.getTupleDimensionality());
            iter.setDimensionality(iterDimensionality);
            iter.setCurrenTuplePos(posIntTuple);
            posIntTuple += iter.getTupleNumberOfMembers();
        }
        if (this.applyAutoExistsForOneTupleList((ArrayList<CjFastListBaseIterator>)iteratorList)) {
            this.isEmpty = true;
            return null;
        }
        if (this.setupNonEmpty((ArrayList<CjFastListBaseIterator>)iteratorList)) {
            this.isEmpty = true;
            return null;
        }
        List<CjFastListBaseIterator> oneIter = iteratorList.stream().filter(OlapFastCrossjoinIterator::canBeFilterOutOfCrossjoin).collect(Collectors.toList());
        List<CjFastListBaseIterator> actualIter = iteratorList.stream().filter(t -> !OlapFastCrossjoinIterator.canBeFilterOutOfCrossjoin(t)).collect(Collectors.toList());
        if (actualIter.isEmpty()) {
            this.actualIterator = new CjFastActualSingleItemIterator(oneIter, this.tupleDimensionality, completers);
            return null;
        }
        for (int i = 0; i < actualIter.size(); ++i) {
            CjFastListBaseIterator iter = (CjFastListBaseIterator)actualIter.get(i);
            if (iter.isInitialBitMapWasNull() && this.context.hasNonEmpty()) {
                iter.addOnTheFlyReducer(new CjFastListBaseIterator.NoneEmpty(this.context, iter.index));
                throw new RuntimeException("ouch!");
            }
            if (i == 0) {
                iter = iter.toFirstIterator();
                actualIter.set(0, iter);
            } else {
                iter.addCacheForOnTheFlyReducer();
            }
            CjFastListBaseIterator nextIter = i == actualIter.size() - 1 ? null : actualIter.get(i + 1);
            partialDimensionality = OlapTupleDimensionalityFactory.createUnionEx(this.cache, partialDimensionality, iter.getTupleDimensionality());
            iter.setIndex(i);
            iter.setPartialDimensionality(partialDimensionality);
            iter.setNext((CjFastListIterator)nextIter);
        }
        LOGGER.debug((Object)"[fast-crossjoin] adding reducers");
        List<CjFastTwoReducer> reducers = this.addReducers(actualIter);
        LOGGER.debug((Object)("[fast-crossjoin] reducers count : " + reducers.size()));
        this.infoSize = actualIter.stream().map(tuples -> String.valueOf(tuples.getTuplesCount())).collect(Collectors.joining(" x ", " (", ")"));
        this.infoSize = this.infoSize + " : tuples count = " + CdStringUtils.formatNice((long)actualIter.stream().map(CjFastListBaseIterator::getTuplesCount).reduce(0, Integer::sum).intValue());
        LOGGER.debug((Object)("[fast-crossjoin] sets optimized " + this.infoSize));
        this.actualIterator = new CjFastActualIterator(actualIter, oneIter, this.tupleDimensionality, completers);
        return reducers;
    }

    private List<ICjIteratorTupleCompleter> shrinkAttributesToOneList(ArrayList<CjFastListBaseIterator> iteratorList) {
        ArrayList<ICjIteratorTupleCompleter> completers = new ArrayList<ICjIteratorTupleCompleter>();
        if (!this.context.getRequestProperties().isMdxCrossjoinWithAttributes()) {
            return completers;
        }
        IntOpenHashSet simplified = new IntOpenHashSet();
        HashMap<Integer, ArrayList> attributesBeforBase = new HashMap<Integer, ArrayList>();
        for (int i = 0; i < iteratorList.size(); ++i) {
            if (simplified.contains(i)) continue;
            CjFastListBaseIterator itI = iteratorList.get(i);
            OlapHierarchy hierI = itI.getOlapHierarchy();
            for (int j = i + 1; j < iteratorList.size() && hierI != null; ++j) {
                if (simplified.contains(j) || !this.isIteratorMembersOfAll.contains(j)) continue;
                CjFastListBaseIterator itJ = iteratorList.get(j);
                OlapHierarchy hierJ = itJ.getOlapHierarchy();
                OlapLevel levelI = itI.getOlapLevel();
                OlapLevel levelJ = itJ.getOlapLevel();
                if (levelJ == null || levelI == null) continue;
                if (levelJ.isAttributeLevelOf(levelI)) {
                    if (!levelJ.isLast() || !levelI.isLast() || levelJ.getMemberCount() != itJ.getTuplesCount()) continue;
                    completers.add(new CjIteratorTupleCompleter(i, j, hierI, hierJ));
                    iteratorList.set(j, CjFastListBaseIterator.create(this.context, Collections.singletonList(new OlapAll4FactMember(levelJ)), j));
                    simplified.add(j);
                    continue;
                }
                if (hierI.getAttributeOfHierarchy() != hierJ || !levelI.isLast()) continue;
                attributesBeforBase.computeIfAbsent(j, l -> new ArrayList()).add(i);
                simplified.add(i);
            }
        }
        attributesBeforBase.forEach((baseList, attributesBeforeBase) -> {
            ICjIteratorTupleCompleter completer = this.solveAttributesBeforeMain(iteratorList, (int)baseList, (List<Integer>)attributesBeforeBase);
            if (completer != null) {
                completers.addFirst(completer);
            }
        });
        return completers;
    }

    private ICjIteratorTupleCompleter solveAttributesBeforeMain(ArrayList<CjFastListBaseIterator> iteratorList, final int baseMemberListIdx, List<Integer> attributesBeforeBase) {
        attributesBeforeBase.sort(Integer::compare);
        if (baseMemberListIdx != attributesBeforeBase.getLast() + 1) {
            return null;
        }
        int slice = -1;
        for (int i = 1; i < attributesBeforeBase.size(); ++i) {
            if (attributesBeforeBase.get(i - 1) + 1 == attributesBeforeBase.get(i)) continue;
            slice = i;
        }
        if (slice != -1) {
            attributesBeforeBase = attributesBeforeBase.subList(slice, attributesBeforeBase.size());
        }
        List<Map> attributesPos = attributesBeforeBase.stream().map(attrListIdx -> {
            HashMap<OlapMember, Integer> members = new HashMap<OlapMember, Integer>();
            List<OlapTuple> attrTupleList = ((CjFastListBaseIterator)iteratorList.get((int)attrListIdx.intValue())).tupleList;
            for (int i = 0; i < attrTupleList.size(); ++i) {
                members.put((OlapMember)attrTupleList.get(i), i);
            }
            return members;
        }).toList();
        final List<OlapHierarchy> hierarchies = attributesBeforeBase.stream().map(idx -> ((CjFastListBaseIterator)iteratorList.get((int)idx)).getOlapHierarchy()).toList();
        OlapMember[] baseExistingMembers = (OlapMember[])iteratorList.get((int)baseMemberListIdx).tupleList.toArray(OlapMember[]::new);
        ConcurrentHashMap.KeySetView noMatching = ConcurrentHashMap.newKeySet();
        iteratorList.get((int)baseMemberListIdx).tupleList.parallelStream().forEach(baseTuple -> {
            for (int i = 0; i < attributesPos.size(); ++i) {
                OlapMember baseMember;
                OlapMember attrMember1;
                Map fPos = (Map)attributesPos.get(i);
                if (fPos.containsKey(attrMember1 = (baseMember = (OlapMember)baseTuple).getAttributeMember((OlapHierarchy)hierarchies.get(i)))) continue;
                noMatching.add(baseMember);
                return;
            }
        });
        if (!noMatching.isEmpty()) {
            baseExistingMembers = (OlapMember[])Arrays.stream(baseExistingMembers).filter(m -> !noMatching.contains(m)).toArray(OlapMember[]::new);
        }
        Arrays.parallelSort(baseExistingMembers, (o1, o2) -> {
            for (int i = 0; i < attributesPos.size(); ++i) {
                int posAttr2;
                Map fPos = (Map)attributesPos.get(i);
                OlapMember attrMember1 = o1.getAttributeMember((OlapHierarchy)hierarchies.get(i));
                OlapMember attrMember2 = o2.getAttributeMember((OlapHierarchy)hierarchies.get(i));
                int posAttr1 = (Integer)fPos.get(attrMember1);
                int comp = Integer.compare(posAttr1, posAttr2 = ((Integer)fPos.get(attrMember2)).intValue());
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        });
        for (int i = 0; i < attributesBeforeBase.size(); ++i) {
            int idx2 = attributesBeforeBase.get(i);
            if (i == 0) {
                List<OlapTuple> members = Arrays.stream(baseExistingMembers).collect(Collectors.toUnmodifiableList());
                iteratorList.set(idx2, CjFastListBaseIterator.create(this.context, members, idx2));
                continue;
            }
            iteratorList.set(idx2, CjFastListBaseIterator.create(this.context, Collections.singletonList(new OlapAll4FactMember(iteratorList.get(idx2).getOlapLevel())), idx2));
        }
        iteratorList.set(baseMemberListIdx, CjFastListBaseIterator.create(this.context, Collections.singletonList(new OlapAll4FactMember(iteratorList.get(baseMemberListIdx).getOlapLevel())), baseMemberListIdx));
        final int firstAttribute = attributesBeforeBase.getFirst();
        final List<Integer> fattributesBeforeBase = attributesBeforeBase;
        return new ICjIteratorTupleCompleter(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public boolean complete(OlapMember[] currCombination) {
                OlapMember baseMember;
                currCombination[baseMemberListIdx] = baseMember = currCombination[firstAttribute];
                for (int attributeIdx = 0; attributeIdx < fattributesBeforeBase.size(); ++attributeIdx) {
                    currCombination[((Integer)fattributesBeforeBase.get((int)attributeIdx)).intValue()] = baseMember.getAttributeMember((OlapHierarchy)hierarchies.get(attributeIdx));
                }
                return true;
            }

            @Override
            public String log() {
                return "(" + fattributesBeforeBase.stream().map(Object::toString).collect(Collectors.joining(",")) + ") on base (" + baseMemberListIdx + ")";
            }
        };
    }

    private static boolean canBeFilterOutOfCrossjoin(CjFastListBaseIterator iter) {
        return iter.getTuplesCount() == 1;
    }

    private boolean applyAutoExistsForOneTupleList(ArrayList<CjFastListBaseIterator> iteratorList) {
        HashSet<Integer> intSet = new HashSet<Integer>();
        for (int i = 0; i < iteratorList.size(); ++i) {
            CjFastListBaseIterator iterI = iteratorList.get(i);
            OlapTuple iterISingleTuple = iterI.getOneTuple();
            if (iterI.getTuplesCount() != 1 || iterISingleTuple.existAllways() || iterISingleTuple.isAllForFacts()) continue;
            for (int j = 0; j < iteratorList.size(); ++j) {
                CjFastTwoFilter autoExist;
                CjFastListBaseIterator iterJ;
                if (j == i || (iterJ = iteratorList.get(j)).getOneTuple().isAllForFacts() || (autoExist = CjFastTwoAutoExistBuilder.create(this.context, iterI, iterJ)) == null) continue;
                autoExist.performInit();
                if (autoExist.isBitmapBased()) {
                    CjBitmapHelper.CjBitmap bitmap2 = autoExist.getBitmap(iterISingleTuple, 0);
                    if (bitmap2 == null || bitmap2.isEmpty()) {
                        return true;
                    }
                    if (bitmap2.cardinality() == (long)iterJ.getTuplesCount()) continue;
                    if (bitmap2.cardinality() == 1L && iterJ.getTuplesCount() != 1) {
                        i = j;
                    }
                    iterJ.resetInitialBitmap(bitmap2);
                    intSet.add(j);
                    continue;
                }
                iterJ.addOnTheFlyReducer((tuple2, index2) -> autoExist.isNoEmpty(iterISingleTuple, tuple2, 0, index2));
            }
        }
        if (intSet.isEmpty() || this.context.hasNonEmpty()) {
            // empty if block
        }
        return false;
    }

    private boolean setupNonEmpty(ArrayList<CjFastListBaseIterator> iteratorList) {
        if (this.context.hasNonEmpty()) {
            List<List<OlapTuple>> setAsList = iteratorList.stream().map(iter -> iter.tupleList).collect(Collectors.toList());
            List<CjBitmapHelper.CjBitmap> bitmaps = this.context.fastcrossjoin_init(setAsList, this.tupleDimensionality, this.itemLimit != -1 ? 1000 : -1);
            if (bitmaps.isEmpty()) {
                return true;
            }
            for (int i = 0; i < iteratorList.size(); ++i) {
                CjFastListBaseIterator cjFastListBaseIterator = iteratorList.get(i);
                cjFastListBaseIterator.setInitialBitmap();
                cjFastListBaseIterator.resetInitialBitmap(bitmaps.get(i));
            }
        }
        return false;
    }

    private List<CjFastTwoReducer> addReducers(List<CjFastListBaseIterator> iteratorList) {
        ArrayList<CjFastTwoReducer> reducers = new ArrayList<CjFastTwoReducer>();
        for (int i = 0; i < iteratorList.size(); ++i) {
            CjFastListBaseIterator iterI = iteratorList.get(i);
            for (int j = i + 1; j < iteratorList.size(); ++j) {
                CjFastListIterator iterJ = (CjFastListIterator)iteratorList.get(j);
                long start = System.currentTimeMillis();
                CjFastTwoReducer reducer = CjFastTwoReducer.create(this.context, iterI, iterJ);
                if (reducer == null) continue;
                reducers.add(reducer);
                iterI.addReducer(reducer);
                LOGGER.debug((Object)("[fast-crossjoin] add reducer for (" + i + ", " + j + ") - " + reducer.logName() + " - " + CdTimeUtils.formatMillisEx((long)start)));
            }
        }
        return reducers;
    }

    @Override
    public List<List<OlapTuple>> asCrossjoinMaterializedTuples() {
        ArrayList<List<OlapTuple>> converted = new ArrayList<List<OlapTuple>>();
        for (int ii = 0; ii < this.originalIterators.size(); ++ii) {
            OlapTuple tuple;
            ArrayList<OlapTuple> tuples = new ArrayList<OlapTuple>();
            OlapIterator<? extends OlapTuple> axisTuples = this.originalIterators.get(ii);
            axisTuples.reset();
            while ((tuple = axisTuples.next()) != null) {
                tuples.add(tuple);
            }
            converted.add(tuples);
        }
        return converted;
    }

    @Override
    public void hackForNonEmptyX() {
        this.context.hackForNonEmptyX();
    }

    private /* synthetic */ void lambda$doSetupFastIterators$0(ArrayList iteratorList, List setAsList, int i) {
        iteratorList.add(CjFastListBaseIterator.create(this.context, (List)setAsList.get(i), i));
    }
}

