/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.collection.CdArrayList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListFirstIterator;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class CjFastListIterator
extends CjFastListBaseIterator {
    final CdArrayList<CjBitmapHelper.CjTupleListReducer> reducingBitmaps = new CdArrayList();
    protected int nextPoint;
    private CjBitmapHelper.Iterator iter;
    private boolean iterationFinished = false;

    CjFastListIterator(OlapFastCrossjoinContext context, List<OlapTuple> currentTupleList, int index) {
        super(context, currentTupleList, index);
        this.reducingBitmaps.add((Object)CjBitmapHelper.createBitmapAllOnes(this.tupleList.size()));
    }

    CjFastListIterator(CjFastListIterator other) {
        super(other);
        this.reducingBitmaps.add((Object)other.getReducingBitmap(0));
    }

    @Override
    public CjFastListBaseIterator toFirstIterator() {
        return new CjFastListFirstIterator(this);
    }

    @Override
    protected void resetTupleList(List<OlapTuple> tupleList) {
        super.resetTupleList(tupleList);
        this.reducingBitmaps.set(0, (Object)CjBitmapHelper.createBitmapAllOnes(tupleList.size()));
    }

    @Override
    @Nullable
    public void reset(boolean reducingDone) {
        if (this.iterationFinished && this.singleOnTheFlyReducer != null) {
            this.reduceOnSingleOnTheFly();
        }
        this.reducingDone = reducingDone;
        this.iter = this.getReducingBitmap(this.reducingBitmaps.size() - 1).getIterator();
    }

    @Override
    public final boolean next(OlapMember[] currentTuple, OlapMember[] currCombination4NonEmpty) {
        boolean stop;
        do {
            stop = true;
            this.nextPoint = this.iter.next();
            if (this.nextPoint == -1) {
                this.iterationFinished = true;
                return false;
            }
            OlapTuple tuple = (OlapTuple)this.tupleList.get(this.nextPoint);
            if (this.singleOnTheFlyReducer == null || this.singleOnTheFlyReducer.exists(tuple, this.nextPoint)) {
                stop = this.addMemberToCurrent(currentTuple, currCombination4NonEmpty, tuple);
                if (!stop || this.next == null) continue;
                stop = this.reduceNextIterators(tuple, this.nextPoint, this.asNonEmptyFilteringTuple(currCombination4NonEmpty, tuple));
                continue;
            }
            stop = false;
        } while (!stop);
        return true;
    }

    protected boolean addMemberToCurrent(OlapMember[] currentTuple, OlapMember[] currTuple4NonEmpty, OlapTuple tuple) {
        tuple.addMembersInArray(currentTuple, this.currenTuplePos);
        tuple.addMembersInArray(currTuple4NonEmpty, this.currenTuplePos);
        return true;
    }

    private void reduceOnSingleOnTheFly() {
        CjFastListBaseIterator.CacheReducer cache;
        if (this.singleOnTheFlyReducer instanceof CjFastListBaseIterator.CacheReducer && (cache = (CjFastListBaseIterator.CacheReducer)this.singleOnTheFlyReducer).isFullEvaluated(this.tupleList.size())) {
            for (int i = 0; i < this.reducingBitmaps.size(); ++i) {
                CjBitmapHelper.CjTupleListReducer bitmap = (CjBitmapHelper.CjTupleListReducer)this.reducingBitmaps.get(i);
                this.reducingBitmaps.set(i, (Object)CjBitmapHelper.and(cache.bitset, bitmap));
            }
            this.singleOnTheFlyReducer = null;
        }
    }

    @Override
    public CjFastListIterator newCopy() {
        return new CjFastListIterator(this);
    }

    protected OlapTuple asNonEmptyFilteringTuple(OlapMember[] currentCrossjoin, OlapTuple currentIterTuple) {
        OlapTuple tuple;
        int numberOfMembers = this.currenTuplePos + currentIterTuple.getMemberCount();
        if (numberOfMembers == 1) {
            tuple = currentIterTuple;
        } else {
            OlapMember[] members = new OlapMember[numberOfMembers];
            System.arraycopy(currentCrossjoin, 0, members, 0, numberOfMembers);
            tuple = OlapTupleFactory.instance(this.partialDimensionality, members);
        }
        return tuple;
    }

    CjBitmapHelper.CjTupleListReducer getReducingBitmap(int index) {
        for (int i = index; i >= 0; --i) {
            CjBitmapHelper.CjTupleListReducer bitmap = (CjBitmapHelper.CjTupleListReducer)this.reducingBitmaps.getExtra(i, null);
            if (bitmap == null) continue;
            return bitmap;
        }
        throw new CdShouldNotBeHereProgrammingException();
    }
}

