/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.collection.CdPair;
import crazydev.common.collection.CdSortedList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListFirstIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastTwoReducer;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionality;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

abstract class CjFastListBaseIterator {
    protected final OlapFastCrossjoinContext context;
    private final int numberOfMembers;
    protected OlapDimensionality dimensionality;
    @Nullable
    protected CjFastListIterator next;
    protected int currenTuplePos;
    protected OlapTupleDimensionality partialDimensionality;
    protected boolean reducingDone;
    @Nullable
    protected SingleReducer singleOnTheFlyReducer;
    int index;
    List<OlapTuple> tupleList;
    private final CdSortedList<CjFastTwoReducer> reducers = new CdSortedList((a, b) -> Integer.compare(a.to.getTuplesCount(), b.to.getTuplesCount()));
    MutableObject<OlapLevel> mutableLevel = null;
    MutableObject<List<OlapLevel>> mutableLevels = null;
    private boolean initialBitMapWasNull;
    private long statsCountEmpty;
    private long statsCountEmptyFunctionCall;

    CjFastListBaseIterator(OlapFastCrossjoinContext context, List<OlapTuple> currentTupleList, int index) {
        this.context = context;
        this.tupleList = currentTupleList;
        this.index = index;
        this.numberOfMembers = this.tupleList.get(0).getMemberCount();
        this.initialBitMapWasNull = true;
    }

    CjFastListBaseIterator(CjFastListBaseIterator other) {
        this.context = other.context;
        this.index = other.index;
        this.tupleList = other.tupleList;
        this.numberOfMembers = other.numberOfMembers;
        this.currenTuplePos = other.currenTuplePos;
        this.partialDimensionality = other.partialDimensionality;
        this.dimensionality = other.dimensionality;
        this.singleOnTheFlyReducer = other.singleOnTheFlyReducer == null ? null : other.singleOnTheFlyReducer.copy();
        this.initialBitMapWasNull = other.initialBitMapWasNull;
    }

    protected void resetTupleList(List<OlapTuple> tupleList) {
        this.tupleList = tupleList;
    }

    void setInitialBitmap() {
        this.initialBitMapWasNull = false;
    }

    final void resetInitialBitmap(CjBitmapHelper.CjBitmap bitmap) {
        this.resetTupleList(CjFastListBaseIterator.reduceList(this.tupleList, bitmap));
    }

    static CjFastListBaseIterator create(OlapFastCrossjoinContext context, List<OlapTuple> currentTupleList, int index) {
        if (index == 0) {
            return new CjFastListFirstIterator(context, currentTupleList, index);
        }
        return new CjFastListIterator(context, currentTupleList, index);
    }

    private static List<OlapTuple> reduceList(List<OlapTuple> tupleList, @Nullable CjBitmapHelper.CjBitmap filter) {
        if (filter == null || filter.cardinality() == (long)tupleList.size()) {
            return tupleList;
        }
        ArrayList<OlapTuple> tuples = new ArrayList<OlapTuple>((int)filter.cardinality());
        filter.forEach(i -> tuples.add((OlapTuple)tupleList.get(i)));
        return tuples;
    }

    final void setNext(@Nullable CjFastListIterator next) {
        this.next = next;
    }

    final void setPartialDimensionality(OlapTupleDimensionality partialDimensionality) {
        this.partialDimensionality = partialDimensionality;
    }

    public abstract void reset(boolean var1);

    public abstract boolean next(OlapMember[] var1, OlapMember[] var2);

    final boolean reduceNextIterators(OlapTuple currentTuple, int currentTupleIndex, OlapTuple reducingMembers) {
        int fasscrossjoin_done;
        List<CjBitmapHelper.CjTupleListReducer> newReducingBitmap;
        int reducingIndex = this.index + 1;
        if (!this.reducers.isEmpty() && !this.applyReducers(currentTuple, currentTupleIndex)) {
            return false;
        }
        if (!this.context.hasNonEmpty()) {
            this.next.reset(false);
            return true;
        }
        ArrayList<CjBitmapHelper.CjTupleListReducer> reducedList = new ArrayList<CjBitmapHelper.CjTupleListReducer>();
        CjFastListIterator next = this.next;
        while (next != null) {
            int index = reducingIndex - (this.reducers.containsSlow((Object)next) ? 0 : 1);
            CjBitmapHelper.CjTupleListReducer bitmap = (CjBitmapHelper.CjTupleListReducer)next.reducingBitmaps.get(index);
            this.statsCountEmpty += bitmap.cardinality();
            reducedList.add(bitmap);
            next = next.next;
        }
        if (!this.reducingDone && this.tupleList.size() != 1) {
            CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> reducing = this.context.fastcrossjoin_reduce(reducingIndex, reducedList, reducingMembers);
            newReducingBitmap = (List)reducing.fst;
            fasscrossjoin_done = (Integer)reducing.snd;
            ++this.statsCountEmptyFunctionCall;
        } else {
            newReducingBitmap = reducedList;
            fasscrossjoin_done = 0;
        }
        if (newReducingBitmap.isEmpty()) {
            return false;
        }
        next = this.next;
        for (int i = 0; i < newReducingBitmap.size(); ++i) {
            CjBitmapHelper.CjTupleListReducer olapBitmap = newReducingBitmap.get(i);
            if (olapBitmap.isEmpty()) {
                return false;
            }
            next.reducingBitmaps.set(reducingIndex, (Object)olapBitmap);
            next.reset(fasscrossjoin_done > i);
            next = next.next;
        }
        return true;
    }

    private boolean applyReducers(OlapTuple currentTuple, int currentTupleIndex) {
        for (int i = 0; i < this.reducers.size(); ++i) {
            if (((CjFastTwoReducer)this.reducers.get(i)).onNewCurrentTuple(currentTuple, currentTupleIndex)) continue;
            return false;
        }
        return true;
    }

    final int index() {
        return this.index;
    }

    final int getTupleNumberOfMembers() {
        return this.numberOfMembers;
    }

    final void setCurrenTuplePos(int currenTuplePos) {
        this.currenTuplePos = currenTuplePos;
    }

    final OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleList.get(0).getTupleDimensionality();
    }

    OlapDimensionality getDimensionality() {
        return this.dimensionality;
    }

    final void setDimensionality(OlapDimensionality iterDimensionality) {
        this.dimensionality = iterDimensionality;
    }

    void addReducer(CjFastTwoReducer reducer) {
        if (reducer.from != this) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        this.reducers.add((Object)reducer);
    }

    final OlapTuple getOneTuple() {
        return this.tupleList.get(0);
    }

    final long getStatsCountEmpty() {
        return this.statsCountEmpty;
    }

    final long getStatsCountEmptyFunctionCall() {
        return this.statsCountEmptyFunctionCall;
    }

    int getTuplesCount() {
        return this.tupleList.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof CjFastTwoReducer) {
            CjFastTwoReducer that = (CjFastTwoReducer)o;
            return this == that.to;
        }
        throw new CdShouldNotBeHereProgrammingException();
    }

    boolean isNotFiltering(CjBitmapHelper.CjTupleListReducer nextBitmap) {
        return (long)this.tupleList.size() == nextBitmap.cardinality();
    }

    public abstract CjFastListBaseIterator newCopy();

    public void setIterateOnly(int iterateOnly) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public boolean hasItemAtPosition(int iterateOnly) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    void cloneReducers(CjFastListBaseIterator oldIter, List<CjFastListBaseIterator> newIterators) {
        oldIter.reducers.forEach(reducer -> this.reducers.add((Object)reducer.newClone(newIterators)));
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public abstract CjFastListBaseIterator toFirstIterator();

    void addOnTheFlyReducer(SingleReducer red) {
        this.singleOnTheFlyReducer = red.join(this.singleOnTheFlyReducer);
    }

    void addCacheForOnTheFlyReducer() {
        if (this.singleOnTheFlyReducer != null) {
            this.singleOnTheFlyReducer = new CacheReducer(this.singleOnTheFlyReducer);
        }
    }

    public boolean isInitialBitMapWasNull() {
        return this.initialBitMapWasNull;
    }

    @Nullable
    public OlapDimension getOlapDimension() {
        OlapTuple oneTuple = this.getOneTuple();
        return oneTuple.getMemberCount() == 1 ? oneTuple.getMember(0).getDimension() : null;
    }

    public OlapHierarchy getOlapHierarchy() {
        OlapTuple oneTuple = this.getOneTuple();
        return oneTuple.getMemberCount() == 1 ? oneTuple.getMember(0).getHierarchy() : null;
    }

    public OlapLevel getOlapLevel() {
        if (this.mutableLevel == null) {
            this.mutableLevel = new MutableObject();
            this.mutableLevels = new MutableObject();
            OlapTuple tuple = this.tupleList.getFirst();
            if (tuple.getMemberCount() != 1) {
                return null;
            }
            OlapLevel[] levels = new OlapLevel[tuple.getMember(0).getHierarchy().getLastLevel().getDepth() + 1];
            for (OlapTuple member : this.tupleList) {
                OlapLevel level;
                levels[level.getDepth()] = level = member.getMember(0).getLevel();
            }
            List<OlapLevel> listLevels = Stream.of(levels).filter(Objects::nonNull).toList();
            if (listLevels.size() == 1) {
                this.mutableLevel.setValue((Object)((OlapLevel)listLevels.stream().findFirst().get()));
            }
            this.mutableLevels.setValue(listLevels);
        }
        return (OlapLevel)this.mutableLevel.get();
    }

    public List<OlapLevel> getOlapLevels() {
        if (this.mutableLevel == null) {
            this.getOlapLevel();
        }
        return (List)this.mutableLevels.get();
    }

    @FunctionalInterface
    static interface SingleReducer {
        public boolean exists(OlapTuple var1, int var2);

        default public SingleReducer join(SingleReducer chained) {
            if (chained == null) {
                return this;
            }
            return (tuple1, index1) -> this.exists(tuple1, index1) && chained.exists(tuple1, index1);
        }

        default public SingleReducer copy() {
            return this;
        }
    }

    static class CacheReducer
    implements SingleReducer {
        final CjBitmapHelper.CjBitmap bitset = CjBitmapHelper.createBitmap();
        final CjBitmapHelper.CjBitmap evaluated = CjBitmapHelper.createBitmap();
        final SingleReducer other;

        public CacheReducer(SingleReducer red) {
            this.other = red;
        }

        @Override
        public CacheReducer copy() {
            return new CacheReducer(this.other.copy());
        }

        @Override
        public boolean exists(OlapTuple tuple1, int index1) {
            if (this.evaluated.getBit(index1)) {
                return this.bitset.getBit(index1);
            }
            this.evaluated.setBit(index1);
            if (this.other.exists(tuple1, index1)) {
                this.bitset.setBit(index1);
                return true;
            }
            return false;
        }

        boolean isFullEvaluated(int size) {
            return this.evaluated.cardinality() == (long)size;
        }
    }

    static class NoneEmpty
    implements SingleReducer {
        static final int bucketSize = 1024;
        final CjBitmapHelper.CjBitmap isNotEmpty = CjBitmapHelper.createBitmap();
        final BitSet visited;
        private final int listIndex;
        private final OlapFastCrossjoinContext context;

        public NoneEmpty(OlapFastCrossjoinContext context, int listIndex) {
            this.listIndex = listIndex;
            this.context = context;
            this.visited = new BitSet();
        }

        @Override
        public NoneEmpty copy() {
            return new NoneEmpty(this.context, this.listIndex);
        }

        @Override
        public boolean exists(OlapTuple tuple1, int index1) {
            int bucket = index1 / 1024;
            if (this.visited.get(bucket)) {
                return this.isNotEmpty.getBit(index1);
            }
            int startBucket = bucket * 1024;
            this.context.fastcrossjoin_initReduce(this.isNotEmpty, this.listIndex, startBucket, startBucket + 1024);
            this.visited.set(bucket);
            return this.isNotEmpty.getBit(index1);
        }
    }
}

