/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.collection.CdActionEx;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastBaseTwoAutoExistBaseFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.memory.IOlapMemoryLevelMember;
import crazydev.iccube.olap.entity.option.OlapOption;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapMdxEvaluationCancelled;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nullable;

public abstract class CjFastBaseTwoAttributeAutoExistBuilder
extends CjFastBaseTwoAutoExistBaseFilter {
    public static boolean ACTIVE = true;

    CjFastBaseTwoAttributeAutoExistBuilder(OlapFastCrossjoinContext cjContext, int sizeList2) {
        super(cjContext, sizeList2);
    }

    public static int getAttributeMemberIndex(OlapHierarchy hierAttr, OlapMember leaf) {
        OlapMember member = CjFastBaseTwoAttributeAutoExistBuilder.getNullableAttributeMember(hierAttr, leaf);
        if (member == null) {
            throw new CdShouldNotBeHereProgrammingException("Missing Unknown member in hierarchy " + hierAttr.getUniqueNameX());
        }
        return member.getUniqueHierarchyMemberIndex();
    }

    @Nullable
    public static OlapMember getNullableAttributeMember(OlapHierarchy hierAttr, OlapMember leaf) {
        OlapMember attrMember = leaf.getAttributeMember(hierAttr);
        if (attrMember == null && leaf.isCreatedUnknownMember()) {
            return hierAttr.getLastLevel().getCreatedUnkownMember();
        }
        return attrMember;
    }

    public static CjFastBaseTwoAutoExistBaseFilter create(OlapFastCrossjoinContext cjContext, CjFastListBaseIterator list1, CjFastListBaseIterator list2) {
        if (!ACTIVE) {
            return null;
        }
        OlapHierarchy hier1 = list1.getOlapHierarchy();
        OlapHierarchy hier2 = list2.getOlapHierarchy();
        if (hier1 == null || hier2 == null) {
            return null;
        }
        List<OlapLevel> levels1 = CjFastBaseTwoAttributeAutoExistBuilder.listOfLevels(list1);
        if (levels1.size() == 1 && levels1.getFirst().isAll()) {
            return null;
        }
        List<OlapLevel> levels2 = CjFastBaseTwoAttributeAutoExistBuilder.listOfLevels(list2);
        if (levels2.size() == 1 && levels2.getFirst().isAll()) {
            return null;
        }
        if (hier1 == hier2) {
            return CjSameHierarchy.build(cjContext, list1, list2, levels1, levels2);
        }
        if (hier2.getAttributeOfHierarchy() == hier1) {
            return new CjListListAttribute(cjContext, hier1, hier2, list1, list2, levels1, levels2);
        }
        if (levels1.stream().allMatch(level1 -> level1.isAll() || level1.hasOneRelationWithBase(hier2))) {
            return new CjListListAttributeLike(cjContext, hier1, hier2, list1, list2, levels1, levels2);
        }
        if (hier1.getAttributeOfHierarchy() == hier2) {
            return new CjListAttributeList(cjContext, hier1, hier2, list1, list2, levels1, levels2);
        }
        if (levels2.stream().allMatch(level2 -> level2.isAll() || level2.hasOneRelationWithBase(hier1))) {
            return new CjListAttributeLikeList(cjContext, hier1, hier2, list1, list2, levels1, levels2);
        }
        return null;
    }

    protected void forEachMember(CjFastListBaseIterator list, OlapHierarchy hier, List<OlapLevel> levels, CdActionEx<OlapMember> action) {
        boolean useTupleList;
        OlapLevel lastLevel = hier.getLastLevel();
        List<OlapTuple> tupleList = list.tupleList;
        if (lastLevel == list.getOlapLevel()) {
            tupleList.forEach(m -> action.apply(0, (Object)m.getMember(0)));
        }
        int sumMemberLevels = levels.stream().mapToInt(OlapLevel::getMemberCount).sum();
        boolean bl = useTupleList = tupleList.size() < sumMemberLevels / 2;
        if (useTupleList) {
            for (int i = 0; i < tupleList.size(); ++i) {
                if (CjFastBaseTwoAttributeAutoExistBuilder.checkCanceling(i) && this.cancellingContext.isCancelling()) {
                    throw new OlapMdxEvaluationCancelled();
                }
                int idx = i;
                tupleList.get(i).getMember(0).getDescendants(null, lastLevel, OlapOption.SELF).forEach(m -> action.apply(idx, m));
            }
        } else {
            IOlapMemoryLevelMember dataHandler = lastLevel.getDataHandler();
            dataHandler.forEachMemberEx(action);
        }
    }

    public static class CjSameHierarchy
    extends CjFastBaseTwoAutoExistBaseFilter {
        private final CjFastListBaseIterator list1;
        private final CjFastListBaseIterator list2;
        private final OlapLevel level1;
        private final OlapLevel level2;
        private final boolean level1HasAll;
        private final boolean level2HasAll;

        public CjSameHierarchy(OlapFastCrossjoinContext ctx, CjFastListBaseIterator list1, CjFastListBaseIterator list2, OlapLevel level1, OlapLevel level2, boolean level1HasAll, boolean level2HasAll) {
            super(ctx, list2.tupleList.size());
            this.list1 = list1;
            this.list2 = list2;
            this.level1 = level1;
            this.level2 = level2;
            this.level1HasAll = level1HasAll;
            this.level2HasAll = level2HasAll;
        }

        @Override
        public void performInit() {
            List<OlapTuple> tupleList = this.list1.tupleList;
            if (this.level1HasAll) {
                int allMemberIndex1 = IntStream.range(0, tupleList.size()).filter(i -> ((OlapTuple)tupleList.get(i)).getMember(0).isAll()).findFirst().orElse(-1);
                this.megaBitmap.put(allMemberIndex1, (Object)CjBitmapHelper.createBitmapSingleRange(0, this.list2.tupleList.size()));
            }
            int allMemberIndex2 = this.level2HasAll ? IntStream.range(0, this.list2.tupleList.size()).filter(i -> this.list2.tupleList.get(i).getMember(0).isAll()).findFirst().orElse(-1) : -1;
            if (this.level1.getLevelNumber() > this.level2.getLevelNumber()) {
                int i2;
                Int2IntOpenHashMap map = new Int2IntOpenHashMap();
                for (i2 = 0; i2 < this.list2.tupleList.size(); ++i2) {
                    if (CjSameHierarchy.checkCanceling(i2) && this.cancellingContext.isCancelling()) {
                        throw new OlapMdxEvaluationCancelled();
                    }
                    OlapMember m2 = this.list2.tupleList.get(i2).getMember(0);
                    map.put(m2.getUniqueHierarchyMemberIndex(), i2);
                }
                for (i2 = 0; i2 < tupleList.size(); ++i2) {
                    if (CjSameHierarchy.checkCanceling(i2) && this.cancellingContext.isCancelling()) {
                        throw new OlapMdxEvaluationCancelled();
                    }
                    OlapMember member = tupleList.get(i2).getMember(0);
                    int memberIndex = member.getUniqueHierarchyMemberIndex();
                    int memberIndex2 = member.getAncestor(this.level2).getUniqueHierarchyMemberIndex();
                    if (this.level2HasAll) {
                        this.setMegaBitMap(memberIndex, allMemberIndex2);
                    }
                    if (!map.containsKey(memberIndex2)) continue;
                    this.setMegaBitMap(memberIndex, map.get(memberIndex2));
                }
            } else {
                List<OlapTuple> tupleList2 = this.list2.tupleList;
                for (int index2 = 0; index2 < tupleList2.size(); ++index2) {
                    OlapMember m2 = tupleList2.get(index2).getMember(0);
                    int memberIndex1 = m2.getAncestor(this.level1).getUniqueHierarchyMemberIndex();
                    this.setMegaBitMap(memberIndex1, index2);
                }
            }
        }

        @Override
        public CjBitmapHelper.CjBitmap doGetBitmap(OlapTuple tuple1, int index1) {
            return super.getBitmap(tuple1.getMember(0).getUniqueHierarchyMemberIndex());
        }

        public static CjFastBaseTwoAutoExistBaseFilter build(OlapFastCrossjoinContext ctx, CjFastListBaseIterator list1, CjFastListBaseIterator list2, List<OlapLevel> levels1, List<OlapLevel> levels2) {
            int level2IsAll;
            Optional<OlapLevel> all1 = levels1.stream().filter(OlapLevel::isAll).findFirst();
            Optional<OlapLevel> all2 = levels2.stream().filter(OlapLevel::isAll).findFirst();
            int level1IsAll = all1.isPresent() ? 1 : 0;
            int n = level2IsAll = all2.isPresent() ? 1 : 0;
            if (levels1.size() == 1 + level1IsAll && levels2.size() == 1 + level2IsAll) {
                return new CjSameHierarchy(ctx, list1, list2, all1.orElse(levels1.get(0)), all2.orElse(levels2.get(0)), all1.isPresent(), all2.isPresent());
            }
            return null;
        }
    }

    public static class CjListListAttribute
    extends CjBaseAttribute {
        public CjListListAttribute(OlapFastCrossjoinContext cjContext, OlapHierarchy hier, OlapHierarchy hierAttr, CjFastListBaseIterator list, CjFastListBaseIterator listAttr, List<OlapLevel> levels, List<OlapLevel> levelsAttr) {
            super(cjContext, listAttr.tupleList.size(), hier, hierAttr, list, listAttr, levels, levelsAttr);
        }

        @Override
        public void performInit() {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            IntOpenHashSet alwaysExistMembers = new IntOpenHashSet();
            List<OlapTuple> attrList = this.listAttr.tupleList;
            for (int i = 0; i < attrList.size(); ++i) {
                OlapMember attrMember = attrList.get(i).getMember(0);
                if (attrMember.existAllways()) {
                    alwaysExistMembers.add(attrMember.getUniqueHierarchyMemberIndex());
                }
                map.put(attrMember.getUniqueHierarchyMemberIndex(), i);
            }
            this.forEachMember(this.list, this.hier, this.levels, (CdActionEx<OlapMember>)((CdActionEx)(count, leaf) -> {
                if (CjListListAttribute.checkCanceling(count) && this.cancellingContext.isCancelling()) {
                    throw new OlapMdxEvaluationCancelled();
                }
                if (leaf.existAllways()) {
                    return true;
                }
                int attrMemberIndex = CjListListAttribute.getAttributeMemberIndex(this.hierAttr, leaf);
                if (map.containsKey(attrMemberIndex)) {
                    int list2Index = map.get(attrMemberIndex);
                    this.levels.forEach(listLevel -> {
                        OlapMember m = leaf.getAncestor((OlapLevel)listLevel);
                        int list1MemberIndex = m.getUniqueHierarchyMemberIndex();
                        this.setMegaBitMap(list1MemberIndex, list2Index);
                        alwaysExistMembers.forEach(idx -> this.setMegaBitMap(list1MemberIndex, idx));
                    });
                }
                return true;
            }));
        }

        @Override
        public CjBitmapHelper.CjBitmap doGetBitmap(OlapTuple tuple1, int index1) {
            return super.getBitmap(((OlapMember)tuple1).getUniqueHierarchyMemberIndex());
        }
    }

    public static class CjListListAttributeLike
    extends CjBaseAttribute {
        private CjBitmapHelper.CjBitmap allwaysExistBitmap;

        public CjListListAttributeLike(OlapFastCrossjoinContext cjContext, OlapHierarchy hier, OlapHierarchy hierAttr, CjFastListBaseIterator list, CjFastListBaseIterator listAttr, List<OlapLevel> levels, List<OlapLevel> levelsAttr) {
            super(cjContext, listAttr.tupleList.size(), hier, hierAttr, list, listAttr, levels, levelsAttr);
        }

        @Override
        public void performInit() {
            int i;
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            IntOpenHashSet alwaysExistMembers = new IntOpenHashSet();
            for (i = 0; i < this.listAttr.tupleList.size(); ++i) {
                OlapMember attrMember = this.listAttr.tupleList.get(i).getMember(0);
                if (attrMember.existAllways()) {
                    alwaysExistMembers.add(attrMember.getUniqueHierarchyMemberIndex());
                }
                map.put(attrMember.getUniqueHierarchyMemberIndex(), i);
            }
            for (i = 0; i < this.list.tupleList.size(); ++i) {
                if (CjListListAttributeLike.checkCanceling(i) && this.cancellingContext.isCancelling()) {
                    throw new OlapMdxEvaluationCancelled();
                }
                OlapMember member = this.list.tupleList.get(i).getMember(0);
                if (member.existAllways()) {
                    return;
                }
                OlapMember attrMember = CjListListAttributeLike.getNullableAttributeMember(this.hierAttr, member);
                if (attrMember != null) {
                    this.levelsAttr.forEach(attrLevel -> {
                        int attr2MemberIndex;
                        OlapMember attrMember2 = attrMember.getAncestor((OlapLevel)attrLevel);
                        if (attrMember2 != null && map.containsKey(attr2MemberIndex = attrMember2.getUniqueHierarchyMemberIndex())) {
                            int list2Index = map.get(attr2MemberIndex);
                            int list1MemberIndex = member.getUniqueHierarchyMemberIndex();
                            alwaysExistMembers.forEach(idx -> this.setMegaBitMap(idx, list2Index));
                            this.setMegaBitMap(list1MemberIndex, list2Index);
                        }
                    });
                    continue;
                }
                if (alwaysExistMembers.isEmpty()) continue;
                this.allwaysExistBitmap = CjBitmapHelper.createBitmapOf(alwaysExistMembers.toIntArray());
            }
        }

        @Override
        public CjBitmapHelper.CjBitmap doGetBitmap(OlapTuple tuple1, int index1) {
            CjBitmapHelper.CjBitmap bitmap = super.getBitmap(((OlapMember)tuple1).getUniqueHierarchyMemberIndex());
            return bitmap == null ? this.allwaysExistBitmap : bitmap;
        }
    }

    public static class CjListAttributeList
    extends CjBaseAttribute {
        public CjListAttributeList(OlapFastCrossjoinContext cjContext, OlapHierarchy hierAttr, OlapHierarchy hier, CjFastListBaseIterator listAttr, CjFastListBaseIterator list, List<OlapLevel> levelsAttr, List<OlapLevel> levels) {
            super(cjContext, list.tupleList.size(), hier, hierAttr, list, listAttr, levels, levelsAttr);
        }

        @Override
        public void performInit() {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            List<OlapTuple> tupleList = this.list.tupleList;
            for (int i = 0; i < tupleList.size(); ++i) {
                OlapMember member = tupleList.get(i).getMember(0);
                map.put(member.getUniqueHierarchyMemberIndex(), i);
            }
            this.forEachMember(this.list, this.hier, this.levels, (CdActionEx<OlapMember>)((CdActionEx)(count, leaf) -> {
                if (CjListAttributeList.checkCanceling(count) && this.cancellingContext.isCancelling()) {
                    throw new OlapMdxEvaluationCancelled();
                }
                if (leaf.existAllways()) {
                    return true;
                }
                int list1MemberIndex = CjListAttributeList.getAttributeMemberIndex(this.hierAttr, leaf);
                this.levels.forEach(listLevel -> {
                    OlapMember m = leaf.getAncestor((OlapLevel)listLevel);
                    int mMemberIndex = m.getUniqueHierarchyMemberIndex();
                    if (map.containsKey(mMemberIndex)) {
                        int list2Index = map.get(mMemberIndex);
                        this.setMegaBitMap(list1MemberIndex, list2Index);
                    }
                });
                return true;
            }));
        }

        @Override
        public CjBitmapHelper.CjBitmap doGetBitmap(OlapTuple tuple1, int index1) {
            return super.getBitmap(((OlapMember)tuple1).getUniqueHierarchyMemberIndex());
        }
    }

    public static class CjListAttributeLikeList
    extends CjBaseAttribute {
        public CjListAttributeLikeList(OlapFastCrossjoinContext cjContext, OlapHierarchy hierAttr, OlapHierarchy hier, CjFastListBaseIterator listAttr, CjFastListBaseIterator list, List<OlapLevel> levelsAttr, List<OlapLevel> levels) {
            super(cjContext, list.tupleList.size(), hier, hierAttr, list, listAttr, levels, levelsAttr);
        }

        @Override
        public void performInit() {
            IntOpenHashSet attr = new IntOpenHashSet();
            this.listAttr.tupleList.stream().mapToInt(m -> m.getMember(0).getUniqueHierarchyMemberIndex()).forEach(arg_0 -> ((IntOpenHashSet)attr).add(arg_0));
            List<OlapTuple> tupleList = this.list.tupleList;
            for (int idx = 0; idx < tupleList.size(); ++idx) {
                if (CjListAttributeLikeList.checkCanceling(idx) && this.cancellingContext.isCancelling()) {
                    throw new OlapMdxEvaluationCancelled();
                }
                OlapMember m2 = tupleList.get(idx).getMember(0);
                if (m2.existAllways()) {
                    return;
                }
                OlapMember attrMember = CjListAttributeLikeList.getNullableAttributeMember(this.hierAttr, m2);
                if (attrMember == null) continue;
                int uIdx = idx;
                this.levelsAttr.forEach(attrLevel -> {
                    int list1MemberIndex;
                    OlapMember attrMember2 = attrMember.getAncestor((OlapLevel)attrLevel);
                    if (attrMember2 != null && attr.contains(list1MemberIndex = attrMember2.getUniqueHierarchyMemberIndex())) {
                        this.setMegaBitMap(list1MemberIndex, uIdx);
                    }
                });
            }
        }

        @Override
        public CjBitmapHelper.CjBitmap doGetBitmap(OlapTuple tuple1, int index1) {
            return super.getBitmap(((OlapMember)tuple1).getUniqueHierarchyMemberIndex());
        }
    }

    public static abstract class CjBaseAttribute
    extends CjFastBaseTwoAttributeAutoExistBuilder {
        protected final OlapHierarchy hier;
        protected final OlapHierarchy hierAttr;
        protected final CjFastListBaseIterator list;
        protected final CjFastListBaseIterator listAttr;
        protected final List<OlapLevel> levels;
        protected final List<OlapLevel> levelsAttr;

        CjBaseAttribute(OlapFastCrossjoinContext cjContext, int size2List, OlapHierarchy hier, OlapHierarchy hierAttr, CjFastListBaseIterator list, CjFastListBaseIterator listAttr, List<OlapLevel> levels, List<OlapLevel> levelsAttr) {
            super(cjContext, size2List);
            this.hier = hier;
            this.hierAttr = hierAttr;
            this.list = list;
            this.listAttr = listAttr;
            this.levels = levels;
            this.levelsAttr = levelsAttr;
        }
    }
}

