/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastListIterator;
import crazydev.iccube.collection.olapiterator.fastcj.ICjIteratorTupleCompleter;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTupleFactory;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class CjFastActualIterator
implements CjFastActualBaseIterator {
    private final List<CjFastListBaseIterator> iterators;
    private final OlapMember[] currCombination;
    private final OlapMember[] currCombination4NonEmpty;
    private final OlapTupleDimensionality tupleDimensionality;
    private final List<ICjIteratorTupleCompleter> completers;
    private boolean isFinished;
    private boolean first;
    private CjFastListBaseIterator currentIterator;
    private double statsCountTotalComb;
    private double statsCountComb;

    CjFastActualIterator(List<CjFastListBaseIterator> iterators, List<CjFastListBaseIterator> oneIter, OlapTupleDimensionality tupleDimensionality, List<ICjIteratorTupleCompleter> completers) {
        this.iterators = iterators;
        this.tupleDimensionality = tupleDimensionality;
        this.completers = completers;
        int numberOfMembers = 0;
        this.statsCountTotalComb = 1.0;
        for (CjFastListBaseIterator iterator : iterators) {
            numberOfMembers += iterator.getTupleNumberOfMembers();
            this.statsCountTotalComb *= (double)iterator.getTuplesCount();
        }
        for (CjFastListBaseIterator iterator : oneIter) {
            numberOfMembers += iterator.getTupleNumberOfMembers();
        }
        this.currCombination = new OlapMember[numberOfMembers];
        this.currCombination4NonEmpty = new OlapMember[numberOfMembers];
        if (!oneIter.isEmpty()) {
            for (CjFastListBaseIterator iterator : oneIter) {
                OlapTuple theTuple = iterator.getOneTuple();
                theTuple.addMembersInArray(this.currCombination, iterator.currenTuplePos);
                theTuple.addMembersInArray(this.currCombination4NonEmpty, iterator.currenTuplePos);
            }
        }
        this.isFinished = false;
    }

    private CjFastActualIterator(CjFastActualIterator other) {
        int i;
        this.tupleDimensionality = other.tupleDimensionality;
        this.statsCountTotalComb = other.statsCountTotalComb;
        this.completers = other.completers;
        this.currCombination = new OlapMember[other.currCombination.length];
        this.currCombination4NonEmpty = new OlapMember[other.currCombination.length];
        this.isFinished = false;
        this.iterators = new ArrayList<CjFastListBaseIterator>(other.iterators.size());
        other.iterators.forEach(iter -> this.iterators.add(iter.newCopy()));
        System.arraycopy(other.currCombination, 0, this.currCombination, 0, this.currCombination.length);
        System.arraycopy(other.currCombination4NonEmpty, 0, this.currCombination4NonEmpty, 0, this.currCombination4NonEmpty.length);
        for (i = 0; i < this.iterators.size() - 1; ++i) {
            CjFastListBaseIterator first = this.iterators.get(i);
            CjFastListBaseIterator next = this.iterators.get(i + 1);
            first.setNext((CjFastListIterator)next);
        }
        for (i = 0; i < this.iterators.size(); ++i) {
            CjFastListBaseIterator oIter = other.iterators.get(i);
            CjFastListBaseIterator iter2 = this.iterators.get(i);
            iter2.cloneReducers(oIter, this.iterators);
        }
    }

    CjFastActualIterator newCopy() {
        return new CjFastActualIterator(this);
    }

    @Override
    public void reset() {
        this.iterators.forEach(cjFastListIterator -> cjFastListIterator.reset(false));
        this.isFinished = this.iterators.isEmpty();
        this.first = true;
        this.currentIterator = this.iterators.getLast();
        this.statsCountComb = 0.0;
    }

    @Override
    @Nullable
    public OlapTuple next() {
        OlapTuple tuple;
        if (this.isFinished) {
            return null;
        }
        if (this.first) {
            this.first = false;
            if (!this.advanceMiddleIterators(-1)) {
                this.isFinished = true;
                return null;
            }
        } else if (!this.currentIterator.next(this.currCombination, this.currCombination4NonEmpty)) {
            this.currentIterator.reset(false);
            if (!this.advanceMiddleIterators(this.iterators.size() - 1)) {
                this.isFinished = true;
                return null;
            }
        }
        if ((tuple = this.combinationToTuple()) == null) {
            return this.next();
        }
        this.statsCountComb += 1.0;
        return tuple;
    }

    @Override
    public void logInfo(Logger logger, String infoSize) {
        logger.info((Object)("[fast-crossjoin] (actual) Combinations         : " + CdStringUtils.formatForLogs((double)this.getStatsCountComb())));
        logger.info((Object)("[fast-crossjoin] (actual) Total Members        : " + CdStringUtils.formatForLogs((double)this.getStatsCountTotalComb()) + infoSize));
        logger.info((Object)("[fast-crossjoin] (actual) Empty Function Calls : " + CdStringUtils.formatForLogs((double)this.getStatsCountEmptyFunctionCall())));
        logger.info((Object)("[fast-crossjoin] (actual) Empty Calls          : " + CdStringUtils.formatForLogs((double)this.getStatsCountEmpty())));
    }

    @Nullable
    private boolean advanceMiddleIterators(int current) {
        block0: while (true) {
            CjFastListBaseIterator iterator;
            if (current != -1) {
                while (true) {
                    if (current == 0) {
                        return false;
                    }
                    if ((iterator = this.iterators.get(--current)).next(this.currCombination, this.currCombination4NonEmpty)) break;
                    iterator.reset(false);
                }
            }
            int p = current + 1;
            while (true) {
                if (p >= this.iterators.size()) continue block0;
                iterator = this.iterators.get(p);
                if (!iterator.next(this.currCombination, this.currCombination4NonEmpty)) {
                    iterator.reset(false);
                    current = p;
                    continue block0;
                }
                if (p == this.iterators.size() - 1) {
                    return true;
                }
                ++p;
            }
            break;
        }
    }

    @Nullable
    private OlapTuple combinationToTuple() {
        OlapMember[] members = new OlapMember[this.currCombination.length];
        System.arraycopy(this.currCombination, 0, members, 0, this.currCombination.length);
        for (ICjIteratorTupleCompleter completer : this.completers) {
            if (completer.complete(members)) continue;
            return null;
        }
        return OlapTupleFactory.instance(this.tupleDimensionality, members);
    }

    @Override
    public boolean isEmpty() {
        return this.iterators.isEmpty();
    }

    protected double getStatsCountTotalComb() {
        return this.statsCountTotalComb;
    }

    protected double getStatsCountComb() {
        return this.statsCountComb;
    }

    protected double getStatsCountEmpty() {
        MutableDouble stats = new MutableDouble();
        this.iterators.forEach(t -> stats.add((double)t.getStatsCountEmpty()));
        return stats.doubleValue();
    }

    protected double getStatsCountEmptyFunctionCall() {
        MutableDouble stats = new MutableDouble();
        this.iterators.forEach(t -> stats.add((double)t.getStatsCountEmptyFunctionCall()));
        return stats.doubleValue();
    }

    int getNumberOfTuplesFirstIterator() {
        return this.iterators.get(0).getTuplesCount();
    }

    void setIterateOnly(int itemNumber) {
        this.iterators.get(0).setIterateOnly(itemNumber);
    }

    boolean hasFirstItemAtPosition(int itemNumber) {
        return this.iterators.get(0).hasItemAtPosition(itemNumber);
    }
}

