/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.fastcj;

import com.google.common.util.concurrent.AtomicDouble;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualBaseIterator;
import crazydev.iccube.collection.olapiterator.fastcj.CjFastActualIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CjFastActualAsyncIterator
implements CjFastActualBaseIterator {
    public static final AtomicInteger TEST_RESET_COUNT = new AtomicInteger();
    public static final AtomicInteger BATCH_COUNT = new AtomicInteger(10);
    public static final AtomicInteger BATCH_SIZE = new AtomicInteger(100);
    private static int UID = 0;
    private final OlapFastCrossjoinContext context;
    private final CjFastActualIterator underlying;
    private final int itemLimit;
    private final AtomicDouble statsCountSequential = new AtomicDouble();
    private final AtomicDouble statsCountTotalComb = new AtomicDouble();
    private final AtomicDouble statsCountEmptyFunctionCall = new AtomicDouble();
    private final AtomicDouble statsCountEmpty = new AtomicDouble();
    private final AtomicDouble combinationCount = new AtomicDouble();
    private BlockingQueue<Batch> queue;
    private boolean producerStarted;
    private List<OlapTuple> miniTuples;
    private int miniTuplesPos;
    @Nullable
    private volatile RuntimeException doneOnError;
    private volatile boolean done;

    CjFastActualAsyncIterator(OlapFastCrossjoinContext context, CjFastActualIterator theOne, int itemLimit) {
        this.context = context;
        this.underlying = theOne.newCopy();
        this.itemLimit = itemLimit;
    }

    @Override
    public void reset() {
        TEST_RESET_COUNT.incrementAndGet();
        this.underlying.reset();
        this.statsCountSequential.set(0.0);
        this.statsCountTotalComb.set(0.0);
        this.statsCountEmptyFunctionCall.set(0.0);
        this.statsCountEmpty.set(0.0);
        this.queue = new LinkedBlockingQueue<Batch>(BATCH_COUNT.get());
        this.producerStarted = false;
        this.miniTuples = null;
        this.miniTuplesPos = 0;
        this.combinationCount.set(0.0);
        this.done = false;
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    @Nullable
    public OlapTuple next() {
        if (this.done) {
            return null;
        }
        if (this.itemLimit != -1 && this.combinationCount.get() >= (double)this.itemLimit) {
            this.done = true;
            return null;
        }
        this.getOrComputeMiniTuples();
        if (this.miniTuples == null) {
            this.done = true;
            return null;
        }
        OlapTuple tuple = this.miniTuples.get(this.miniTuplesPos++);
        this.combinationCount.addAndGet(1.0);
        return tuple;
    }

    private void getOrComputeMiniTuples() {
        if (!this.producerStarted) {
            this.start();
        }
        if (this.miniTuples != null && this.miniTuplesPos < this.miniTuples.size()) {
            return;
        }
        while (!this.done && !this.context.isCancelling()) {
            try {
                Batch batch = this.queue.take();
                this.miniTuples = batch.tuples;
                this.miniTuplesPos = 0;
                return;
            }
            catch (InterruptedException ex) {
                RuntimeException error = this.doneOnError;
                if (error != null) {
                    OlapLoggers.MDX_EVALUATION.info((Object)"[fast-crossjoin] async. take interrupted on error ", (Throwable)error);
                    throw error;
                }
                OlapLoggers.MDX_EVALUATION.info((Object)"[fast-crossjoin] async. take interrupted");
            }
        }
        this.miniTuples = null;
        this.miniTuplesPos = 0;
    }

    private void start() {
        Thread callerThread = Thread.currentThread();
        this.producerStarted = true;
        String threadUID = "FCJ-" + UID++;
        OlapLoggers.MDX_EVALUATION.info((Object)("[fast-crossjoin] async. producer starting " + threadUID));
        new Thread(() -> {
            this.context.registerHousekeeper(() -> {
                OlapLoggers.MDX_EVALUATION.info((Object)("[fast-crossjoin] async. producer " + threadUID + " housekeeping"));
                this.done = true;
                this.queue.clear();
            });
            try {
                int batchSize = BATCH_SIZE.get();
                OlapLoggers.MDX_EVALUATION.info((Object)("[fast-crossjoin] async. producer started batch-size:" + batchSize));
                int batchId = 0;
                while (!this.done && !this.context.isCancelling()) {
                    try {
                        List<OlapTuple> tuples = this.doComputeMiniTuples(batchSize);
                        Batch batch = new Batch(batchId++, tuples);
                        this.queue.put(batch);
                        if (tuples != null) continue;
                        OlapLoggers.MDX_EVALUATION.info((Object)"[fast-crossjoin] async. producer iteration completed");
                        break;
                    }
                    catch (InterruptedException ex) {
                        OlapLoggers.MDX_EVALUATION.info((Object)"[fast-crossjoin] async. producer put interrupted");
                    }
                }
            }
            catch (RuntimeException ex) {
                OlapLoggers.MDX_EVALUATION.error((Object)"[fast-crossjoin] async. producer error", (Throwable)ex);
                this.doneOnError = ex;
                this.done = true;
                callerThread.interrupt();
            }
            finally {
                OlapLoggers.MDX_EVALUATION.info((Object)"[fast-crossjoin] async. producer completed");
            }
        }, threadUID).start();
    }

    private List<OlapTuple> doComputeMiniTuples(int batchSize) {
        OlapTuple tuple;
        ArrayList<OlapTuple> batch = null;
        int count = 0;
        while (count < batchSize && (tuple = this.underlying.next()) != null) {
            if (batch == null) {
                batch = new ArrayList<OlapTuple>();
            }
            batch.add(tuple);
            if (++count % 100 != 0 || !this.context.isCancelling()) continue;
        }
        if (batch != null) {
            this.statsCountTotalComb.addAndGet(this.underlying.getStatsCountTotalComb());
            this.statsCountEmptyFunctionCall.addAndGet(this.underlying.getStatsCountEmptyFunctionCall());
            this.statsCountEmpty.addAndGet(this.underlying.getStatsCountEmpty());
        }
        return batch;
    }

    @Override
    public void logInfo(Logger logger, String infoSize) {
        logger.info((Object)("[fast-crossjoin] (async) Combinations         : " + CdStringUtils.formatForLogs((double)this.combinationCount.get())));
        logger.info((Object)("[fast-crossjoin] (async) Total Members        : " + CdStringUtils.formatForLogs((double)this.statsCountTotalComb.get()) + infoSize));
        logger.info((Object)("[fast-crossjoin] (async) Empty Function Calls : " + CdStringUtils.formatForLogs((double)this.statsCountEmptyFunctionCall.get())));
        logger.info((Object)("[fast-crossjoin] (async) Empty Calls          : " + CdStringUtils.formatForLogs((double)this.statsCountEmpty.get())));
        logger.info((Object)("[fast-crossjoin] (async) Sequential Calls     : " + CdStringUtils.formatForLogs((double)this.statsCountSequential.get())));
    }

    record Batch(int id, @Nullable List<OlapTuple> tuples) {
    }
}

