/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.cache;

import crazydev.common.collection.CdPaginatedList;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.cache.IOlapIteratorCache;
import crazydev.iccube.collection.olapiterator.cache.OlapIteratorCacheMaxSizeException;
import crazydev.iccube.collection.olapiterator.cache.OlapIteratorReadOnlyCache;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class OlapIteratorReadWriteCache<T>
implements IOlapIteratorCache<T> {
    private final int maxCacheSize;
    private final List<T> cache;
    private final OlapIterator<T> underlying;
    private boolean sizeExceeded = false;
    @Nullable
    private volatile OlapIteratorReadOnlyCache<T> done = null;

    public OlapIteratorReadWriteCache(OlapIterator<T> underlying, int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.underlying = underlying;
        this.underlying.reset();
        this.cache = new CdPaginatedList(16384);
    }

    @Override
    public boolean isCrossjoin() {
        return this.underlying.isMembersCrossjoin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOlapIteratorCache<T> asReadOnly() {
        List<T> list = this.cache;
        synchronized (list) {
            return this.done != null ? this.done : this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCachedItem(int pos) throws OlapIteratorCacheMaxSizeException {
        if (this.done != null) {
            return;
        }
        List<T> list = this.cache;
        synchronized (list) {
            if (this.sizeExceeded) {
                throw new OlapIteratorCacheMaxSizeException();
            }
            while (pos >= this.cache.size()) {
                T item = this.underlying.next();
                if (item == null) {
                    this.done = new OlapIteratorReadOnlyCache<T>(this.cache, this.underlying.isMembersCrossjoin());
                    break;
                }
                if (this.maxCacheSize == -1 || this.cache.size() < this.maxCacheSize) {
                    this.cache.add(item);
                    continue;
                }
                this.sizeExceeded = true;
                throw new OlapIteratorCacheMaxSizeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T nextCachedItem(int pos) throws OlapIteratorCacheMaxSizeException {
        this.ensureCachedItem(pos);
        if (this.done != null) {
            return this.done.nextCachedItem(pos);
        }
        List<T> list = this.cache;
        synchronized (list) {
            if (pos < this.cache.size()) {
                return this.cache.get(pos);
            }
            return null;
        }
    }

    @Override
    public OlapIterator<T> newUnderlyingInstance() {
        return this.underlying.newInstance();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

