/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator.cache;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.cache.IOlapIteratorCache;
import java.util.List;

class OlapIteratorReadOnlyCache<T>
implements IOlapIteratorCache<T> {
    private final List<T> cache;
    private final int cacheSize;
    private final boolean crossjoin;

    public OlapIteratorReadOnlyCache(List<T> cache, boolean crossjoin) {
        this.cache = cache;
        this.cacheSize = cache.size();
        this.crossjoin = crossjoin;
    }

    @Override
    public boolean isCrossjoin() {
        return this.crossjoin;
    }

    @Override
    public OlapIteratorReadOnlyCache<T> asReadOnly() {
        return this;
    }

    @Override
    public T nextCachedItem(int pos) {
        if (pos < this.cacheSize) {
            return this.cache.get(pos);
        }
        return null;
    }

    @Override
    public OlapIterator<T> newUnderlyingInstance() {
        throw new CdShouldNotBeHereProgrammingException("internal error : unexpected iterator usage");
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

