/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class OlapTailIterator<T>
extends OlapBaseIterator<T> {
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;
    private final int count;
    private final ArrayList<T> items;
    private final int firstElementArrayPos;
    private int pos;

    OlapTailIterator(OlapIterator<T> iterator, int count) {
        this.count = count;
        this.items = new ArrayList();
        this.firstElementArrayPos = this.initArray(iterator, count);
        this.tupleDimensionality = OlapTailIterator.initTupleDimensionality(this.items);
    }

    private OlapTailIterator(int count, ArrayList<T> items, int firstElementArrayPos) {
        this.items = items;
        this.count = count;
        this.firstElementArrayPos = firstElementArrayPos;
        this.tupleDimensionality = OlapTailIterator.initTupleDimensionality(this.items);
    }

    @Override
    protected boolean tryExtractMeasuresOnTuples() {
        return true;
    }

    @Nullable
    private static <T> OlapTupleDimensionality initTupleDimensionality(List<T> items) {
        T first;
        OlapTupleDimensionality tupleDimensionality = !items.isEmpty() ? ((first = items.get(0)) instanceof OlapTuple ? ((OlapTuple)first).getTupleDimensionality() : null) : null;
        return tupleDimensionality;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.count;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (int pp = 0; pp < this.items.size(); ++pp) {
            T member = this.items.get((this.firstElementArrayPos + pp) % this.count);
            if (!(member instanceof OlapTuple) || !((OlapTuple)member).isCalculated()) continue;
            return true;
        }
        return false;
    }

    private int initArray(OlapIterator<T> iterator, int count) {
        T item;
        iterator.reset();
        int total = 0;
        while ((item = iterator.next()) != null) {
            int listPos = total % count;
            if (listPos >= this.items.size()) {
                this.items.add(item);
            } else {
                this.items.set(listPos, item);
            }
            ++total;
        }
        return total > count ? total % count : 0;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    protected T safeNext() {
        if (this.pos >= this.items.size()) {
            return null;
        }
        int index = (this.firstElementArrayPos + this.pos) % this.count;
        T item = this.items.get(index);
        ++this.pos;
        return item;
    }

    @Override
    public OlapTailIterator<T> newInstance() {
        return new OlapTailIterator<T>(this.count, this.items, this.firstElementArrayPos);
    }
}

