/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseSubSetIterator;

class OlapSubSetIterator<T>
extends OlapBaseSubSetIterator<T> {
    private final int count;
    private int itemsGiven;

    OlapSubSetIterator(OlapIterator<T> iterator, int start, int count) {
        super(iterator, start);
        this.count = count;
    }

    @Override
    public long fastEstimatedSize() {
        return this.count;
    }

    @Override
    public void reset() {
        super.reset();
        this.itemsGiven = 0;
    }

    @Override
    protected T safeNext() {
        if (this.itemsGiven >= this.count) {
            return null;
        }
        ++this.itemsGiven;
        return this.iterator.next();
    }

    @Override
    public boolean _isEmpty() {
        return this.count == 0 || super._isEmpty();
    }

    @Override
    public OlapIterator<T> newInstance() {
        return new OlapSubSetIterator(this.iterator.newInstance(), this.start, this.count);
    }
}

