/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapSingletonIterator<T>
extends OlapBaseIterator<T> {
    private final T member;
    private boolean isOver;

    public OlapSingletonIterator(T member) {
        this.member = member;
        this.reset();
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        if (this.member instanceof OlapTuple) {
            return ((OlapTuple)this.member).getTupleDimensionality();
        }
        return null;
    }

    @Override
    protected boolean tryExtractMeasuresOnTuples() {
        return true;
    }

    @Override
    public long fastEstimatedSize() {
        return 1L;
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.member instanceof OlapTuple && ((OlapTuple)this.member).isCalculated();
    }

    @Override
    public boolean isMembersCrossjoin() {
        return true;
    }

    @Override
    public void reset() {
        this.isOver = false;
    }

    @Override
    @Nullable
    protected T safeNext() {
        if (this.isOver) {
            return null;
        }
        this.isOver = true;
        return this.member;
    }

    @Override
    public boolean _isEmpty() {
        return this.member == null;
    }

    @Override
    public int _sizeSlow() {
        return this.member == null ? 0 : 1;
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        return index == 0 ? (T)this.member : null;
    }

    @Override
    public OlapSingletonIterator<T> newInstance() {
        return new OlapSingletonIterator<T>(this.member);
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }
}

