/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapReverseIterator
extends OlapBaseIterator<OlapTuple> {
    private final OlapListTupleSet<? extends OlapTuple> tupleList;
    private int pos;

    public OlapReverseIterator(OlapListTupleSet<? extends OlapTuple> tupleList) {
        this.tupleList = tupleList;
        this.reset();
    }

    @Override
    protected boolean tryExtractMeasuresOnTuples() {
        return true;
    }

    @Override
    @Nullable
    protected OlapTuple safeNext() {
        if (this.pos < 0) {
            return null;
        }
        return this.tupleList.getItem(this.pos--);
    }

    @Override
    public void reset() {
        this.pos = this.tupleList.size() - 1;
    }

    @Override
    public OlapIterator<OlapTuple> newInstance() {
        return new OlapReverseIterator(this.tupleList);
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleList.getTupleDimensionality();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.tupleList.mightHaveCalcMember();
    }

    @Override
    public long fastEstimatedSize() {
        return this.tupleList.fastEstimatedSize();
    }

    @Override
    public boolean _isEmpty() {
        return this.tupleList.size() == 0;
    }

    @Override
    public int _sizeSlow() {
        return this.tupleList._sizeSlow();
    }

    @Override
    @Nullable
    public OlapTuple _getSlow(int index) {
        return this.tupleList.getItem(index);
    }

    @Override
    public boolean isMembersCrossjoin() {
        return this.tupleList.isMembersCrossjoin();
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }
}

