/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapRangeIterator;

class OlapRangeFromToIterator<T>
extends OlapRangeIterator<T> {
    private final T from;
    private final T to;
    private final boolean forOperator;
    private boolean fromReached;
    private boolean toReached;

    OlapRangeFromToIterator(OlapIterator<T> iterator, T from, T to) {
        super(iterator);
        this.from = from;
        this.to = to;
        this.forOperator = true;
    }

    OlapRangeFromToIterator(OlapIterator<T> iterator, T from, T to, boolean forOperator) {
        super(iterator);
        this.from = from;
        this.to = to;
        this.forOperator = forOperator;
    }

    @Override
    public OlapRangeFromToIterator<T> newInstance() {
        return new OlapRangeFromToIterator(this.iterator.newInstance(), this.from, this.to, this.forOperator);
    }

    @Override
    public void reset() {
        this.iterator.reset();
        this.fromReached = false;
        this.toReached = false;
    }

    @Override
    protected T safeNext() {
        Object member;
        if (this.toReached) {
            return null;
        }
        if (this.fromReached) {
            Object member2 = this.iterator.next();
            if (member2 == null || member2.equals(this.to) || this.forOperator && member2.equals(this.from)) {
                this.toReached = true;
            }
            return member2;
        }
        while ((member = this.iterator.next()) != null) {
            if (!member.equals(this.from) && (!this.forOperator || !member.equals(this.to))) continue;
            this.fromReached = true;
            break;
        }
        this.toReached = member == null || this.from.equals(this.to);
        return member;
    }
}

