/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapMemberChildrenIterator
extends OlapBaseIterator<OlapMember> {
    private final OlapMemberChildren items;
    private final int begin;
    private final int end;
    private int pos = 0;

    public OlapMemberChildrenIterator(OlapMemberChildren children) {
        this.items = children;
        this.begin = 0;
        this.end = children.size();
    }

    private OlapMemberChildrenIterator(OlapMemberChildren children, int begin, int end) {
        this.items = children;
        this.begin = begin;
        this.end = end;
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.items.getTupleDimensionality();
    }

    @Override
    public long fastEstimatedSize() {
        return this.end - this.begin;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (int pp = this.begin; pp < this.end; ++pp) {
            OlapMember member = this.items.get(pp);
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.pos = this.begin;
    }

    @Override
    protected OlapMember safeNext() {
        return this.pos < this.end ? this.items.get(this.pos++) : null;
    }

    @Override
    public boolean _isEmpty() {
        return this.begin >= this.end || this.items.size() == 0;
    }

    @Override
    public int _sizeSlow() {
        return this.items.size();
    }

    @Override
    @Nullable
    public OlapMember _getSlow(int index) {
        return index < this.items.size() ? this.items.get(index) : null;
    }

    public OlapMemberChildrenIterator newInstance() {
        return new OlapMemberChildrenIterator(this.items, this.begin, this.end);
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }
}

