/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapListIterator<T>
extends OlapBaseIterator<T> {
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;
    private final List<T> items;
    private final int begin;
    private final int end;
    private int pos;

    OlapListIterator(List<T> items) {
        this(items, items.size());
    }

    OlapListIterator(List<T> items, int end) {
        this(items, 0, end);
    }

    OlapListIterator(List<T> items, int begin, int end) {
        T first;
        this.items = items;
        this.begin = begin;
        this.end = Math.min(items.size(), end);
        this.tupleDimensionality = !this.items.isEmpty() ? ((first = this.items.get(0)) instanceof OlapTuple ? ((OlapTuple)first).getTupleDimensionality() : null) : null;
    }

    @Override
    protected boolean tryExtractMeasuresOnTuples() {
        return true;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.end - this.begin;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (int pp = this.begin; pp < this.end; ++pp) {
            T member = this.items.get(pp);
            if (!(member instanceof OlapTuple) || !((OlapTuple)member).isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.pos = this.begin;
    }

    @Override
    protected T safeNext() {
        return this.pos < this.end ? (T)this.items.get(this.pos++) : null;
    }

    @Override
    public boolean _isEmpty() {
        return this.begin >= this.end || this.items.size() == 0;
    }

    @Override
    public int _sizeSlow() {
        return this.items.size();
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        return index < this.items.size() ? (T)this.items.get(index) : null;
    }

    @Override
    public OlapListIterator<T> newInstance() {
        return new OlapListIterator<T>(this.items, this.begin, this.end);
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }
}

