/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

class OlapIteratorTransformIterator<T, V>
extends OlapBaseIterator<V> {
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;
    private final OlapIterator<T> iterator;
    private final IOlapIteratorTransform<? super T, V> transform;
    private boolean stop;

    public OlapIteratorTransformIterator(OlapIterator<T> iterator, IOlapIteratorTransform<? super T, V> transform) {
        this.iterator = iterator;
        this.transform = transform;
        this.tupleDimensionality = !this.transform.isTransformingDimensionality() ? this.iterator.getTupleDimensionality() : this.transform.getTupleDimensionality(this.iterator.getTupleDimensionality());
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.transform.fastEstimatedSize(this.iterator.fastEstimatedSize());
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.iterator.mightHaveCalcMember();
    }

    @Override
    public void reset() {
        this.transform.reset();
        this.iterator.reset();
        this.stop = false;
    }

    @Override
    protected V safeNext() {
        if (!this.stop) {
            T item;
            while ((item = this.iterator.next()) != null) {
                if (this.transform.stop(item)) {
                    this.stop = true;
                    break;
                }
                V itemV = this.transform.transform(item);
                if (itemV == null) continue;
                return itemV;
            }
        }
        return null;
    }

    public OlapIteratorTransformIterator<T, V> newInstance() {
        return new OlapIteratorTransformIterator<T, V>(this.iterator.newInstance(), this.transform.newInstance());
    }

    @Override
    public void hackForNonEmptyX() {
        this.iterator.hackForNonEmptyX();
    }
}

