/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import org.jetbrains.annotations.Nullable;

abstract class OlapIteratorListIterator<T extends OlapTuple>
extends OlapBaseIterator<T> {
    private final int iteratorCount;
    private int currentIteratorPos;
    private OlapIterator<T> currentIterator;

    OlapIteratorListIterator(int iteratorCount) {
        this.iteratorCount = iteratorCount;
    }

    @Override
    public void reset() {
        this.currentIteratorPos = 0;
        this.currentIterator = this.getIterator(0);
        this.currentIterator.reset();
    }

    protected abstract OlapIterator<T> getIterator(int var1);

    @Override
    @Nullable
    protected T safeNext() {
        if (this.currentIterator == null) {
            return null;
        }
        OlapTuple next = (OlapTuple)this.currentIterator.next();
        if (next != null) {
            return (T)next;
        }
        if (++this.currentIteratorPos >= this.iteratorCount) {
            this.currentIterator = null;
            return null;
        }
        this.currentIterator = this.getIterator(this.currentIteratorPos);
        this.currentIterator.reset();
        return (T)((OlapTuple)this.next());
    }

    @Override
    public int _sizeSlow() {
        int size = 0;
        for (int idx = 0; idx < this.iteratorCount; ++idx) {
            size += this.getIterator(idx)._sizeSlow();
        }
        return size;
    }

    @Override
    public boolean _isEmpty() {
        for (int idx = 0; idx < this.iteratorCount; ++idx) {
            if (this.getIterator(idx)._isEmpty()) continue;
            return false;
        }
        return true;
    }
}

