/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.collection.OlapIterable;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapArrayIterator;
import crazydev.iccube.collection.olapiterator.OlapChildrenRInverseIterator;
import crazydev.iccube.collection.olapiterator.OlapChildrenRIterator;
import crazydev.iccube.collection.olapiterator.OlapCollectionTransformIterator;
import crazydev.iccube.collection.olapiterator.OlapDistinctTupleIterator;
import crazydev.iccube.collection.olapiterator.OlapEmptyIterator;
import crazydev.iccube.collection.olapiterator.OlapFilterIterator;
import crazydev.iccube.collection.olapiterator.OlapHeadIterator;
import crazydev.iccube.collection.olapiterator.OlapIntegerIterator;
import crazydev.iccube.collection.olapiterator.OlapIteratorTransformIterator;
import crazydev.iccube.collection.olapiterator.OlapListIterator;
import crazydev.iccube.collection.olapiterator.OlapMemberChildrenIterator;
import crazydev.iccube.collection.olapiterator.OlapMultiChildrenRIterator;
import crazydev.iccube.collection.olapiterator.OlapRangeFromIterator;
import crazydev.iccube.collection.olapiterator.OlapRangeFromToIterator;
import crazydev.iccube.collection.olapiterator.OlapRangeToIterator;
import crazydev.iccube.collection.olapiterator.OlapReverseIterator;
import crazydev.iccube.collection.olapiterator.OlapSingletonIterator;
import crazydev.iccube.collection.olapiterator.OlapSubSetIterator;
import crazydev.iccube.collection.olapiterator.OlapTailIterator;
import crazydev.iccube.collection.olapiterator.OlapTupleSetListIterator;
import crazydev.iccube.collection.olapiterator.OlapUnboundedSubSetIterator;
import crazydev.iccube.collection.olapiterator.fastcj.OlapFastCrossjoinIterator;
import crazydev.iccube.olap.entity.common.OlapMemberChildren;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityCache;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionalityHelper;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.filter.dimension.OlapTupleFilter;
import crazydev.iccube.olap.eval.select.context.OlapFastCrossjoinContext;
import crazydev.iccube.olap.eval.select.context.OlapMdxStatementExecutionContext;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapIteratorFactory {
    public static <T> OlapEmptyIterator<T> empty() {
        return OlapEmptyIterator.INSTANCE;
    }

    public static <T> OlapIterator<T> singleton(@Nullable T item) {
        if (item == null) {
            return OlapIteratorFactory.empty();
        }
        return new OlapSingletonIterator<T>(item);
    }

    public static <T> OlapIterator<T> instance(List<T> items) {
        if (items.isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        return new OlapListIterator<T>(items);
    }

    public static OlapIterator<OlapMember> instance(OlapMemberChildren items) {
        return new OlapMemberChildrenIterator(items);
    }

    public static <T> OlapIterator<T> instance(T[] items) {
        if (items.length == 0 || items[0] == null) {
            return OlapIteratorFactory.empty();
        }
        return new OlapArrayIterator<T>(items);
    }

    public static <T> OlapIterator<T> array(T ... items) {
        if (items == null || items.length == 0) {
            return OlapIteratorFactory.empty();
        }
        return new OlapArrayIterator<T>(items);
    }

    public static OlapIntegerIterator integers(int len) {
        return new OlapIntegerIterator(len);
    }

    public static <T, V> OlapIterator<V> transform(List<T> items, IOlapIteratorTransform<? super T, V> transform) {
        return new OlapCollectionTransformIterator<T, V>(items, transform);
    }

    public static <T, V> OlapIterator<V> transform(OlapIterator<T> items, IOlapIteratorTransform<? super T, V> transform) {
        return new OlapIteratorTransformIterator<T, V>(items, transform);
    }

    public static <T> OlapIterator<T> filter(OlapIterator<T> iterator, IOlapIteratorFilter<? super T> filter) {
        return new OlapFilterIterator<T>(iterator, filter);
    }

    public static <T extends OlapTuple> OlapIterator<T> distinct(OlapIterator<T> iterator) {
        return new OlapDistinctTupleIterator<T>(iterator);
    }

    public static <T> OlapIterator<T> head(OlapIterator<T> iterator, int count) {
        return new OlapHeadIterator<T>(iterator, count);
    }

    public static <T> OlapIterator<T> tail(OlapIterator<T> iterator, int count) {
        return new OlapTailIterator<T>(iterator, count);
    }

    public static <T> OlapIterator<T> subset(OlapIterator<T> iterator, int start, int count) {
        if (count == -1) {
            return new OlapUnboundedSubSetIterator<T>(iterator, start);
        }
        return new OlapSubSetIterator<T>(iterator, start, count);
    }

    public static <T> OlapIterator<T> subset(OlapIterator<T> iterator, @Nullable T from, T to) {
        if (from == null) {
            return new OlapRangeToIterator<T>(iterator, to);
        }
        if (to == null) {
            return new OlapRangeFromIterator<T>(iterator, from);
        }
        return new OlapRangeFromToIterator<T>(iterator, from, to);
    }

    public static OlapIterator<OlapTuple> rangeFunction(OlapIterator<OlapTuple> iterator, @Nullable OlapTuple from, @Nullable OlapTuple to) {
        if (from == null) {
            return new OlapRangeToIterator<OlapTuple>(iterator, to);
        }
        if (to == null) {
            return new OlapRangeFromIterator<OlapTuple>(iterator, from);
        }
        return new OlapRangeFromToIterator<OlapTuple>(iterator, from, to, false);
    }

    public static <T> OlapIterator<T> subset(List<T> items, int end) {
        return new OlapListIterator<T>(items, end);
    }

    public static OlapIterator<? extends OlapTuple> union(IOlapEvaluationExceptionContext context, OlapTupleSet<? extends OlapTuple> left, OlapTupleSet<? extends OlapTuple> right, boolean keepDuplicates) {
        return OlapIteratorFactory.union(context, Arrays.asList(left, right), keepDuplicates);
    }

    public static OlapIterator<? extends OlapTuple> union(IOlapEvaluationExceptionContext context, List<OlapTupleSet<? extends OlapTuple>> sets, boolean keepDuplicates) {
        return OlapIteratorFactory.union(context, true, sets, keepDuplicates);
    }

    public static <T extends OlapTuple> OlapIterator<T> union(List<OlapTupleSet<T>> sets, boolean keepDuplicates) {
        if (sets.isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        OlapTupleSetListIterator<T> union = new OlapTupleSetListIterator<T>(sets);
        if (!keepDuplicates) {
            return OlapIteratorFactory.distinct(union);
        }
        return union;
    }

    private static OlapIterator<? extends OlapTuple> union(@Nullable IOlapEvaluationExceptionContext context, boolean assertSetDimensionality, List<OlapTupleSet<? extends OlapTuple>> sets, boolean keepDuplicates) {
        OlapIterator union;
        if (sets.isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        if (sets.size() == 1) {
            union = sets.get(0).getIterator(false);
        } else {
            if (assertSetDimensionality) {
                if (context == null) {
                    throw new CdProgrammingException("Missing evaluation context!");
                }
                OlapTupleDimensionalityHelper.assertUnionDimensionality(context, sets);
            }
            union = new OlapTupleSetListIterator(sets);
        }
        if (!keepDuplicates) {
            return OlapIteratorFactory.distinct(union);
        }
        return union;
    }

    public static OlapIterator<OlapTuple> crossjoin(GFContext context, OlapTupleSet<? extends OlapTuple> left, OlapTupleSet<? extends OlapTuple> right) {
        OlapTupleDimensionalityCache cache = context.getTupleDimensionalityCache();
        return OlapIteratorFactory.crossjoin(context.getStatementExecutionContext(), context, cache, true, context.getTupleFilter(), Arrays.asList(left, right));
    }

    public static OlapIterator<OlapTuple> crossjoin(GFContext context, boolean assertConsistency, List<OlapTupleSet<?>> iterables) {
        return OlapIteratorFactory.crossjoin(context.getStatementExecutionContext(), context, context.getTupleDimensionalityCache(), assertConsistency, context.getTupleFilter(), iterables);
    }

    public static OlapIterator<OlapTuple> crossjoin(GFContext context, GFFunctionArgs args, boolean assertConsistency, List<OlapTupleSet<?>> iterables) {
        return OlapIteratorFactory.crossjoin(context.getStatementExecutionContext(), args.getErrorContext(context), args.getTupleDimensionalityCache(context), assertConsistency, args.getTupleFilter(context), iterables);
    }

    public static OlapIterator<OlapTuple> crossjoin(OlapMdxStatementExecutionContext sContext, IOlapEvaluationExceptionContext errorContext, OlapTupleDimensionalityCache cache, boolean assertConsistency, @Nullable OlapTupleFilter tupleFilter, List<? extends OlapIterable<? extends OlapTuple>> iterables) {
        for (OlapIterable<? extends OlapTuple> olapIterable : iterables) {
            if (olapIterable != null && (!(olapIterable instanceof OlapListTupleSet) || ((OlapListTupleSet)olapIterable).size() != 0)) continue;
            return OlapIteratorFactory.empty();
        }
        OlapFastCrossjoinIterator crossjoin = new OlapFastCrossjoinIterator(new OlapFastCrossjoinContext(sContext, errorContext, S_NonEmptyBehavior.one()), iterables, tupleFilter);
        if (assertConsistency && !crossjoin.isDimensionalityOk()) {
            if (sContext == null) {
                throw new RuntimeException("internal error: missing evaluation context");
            }
            OlapTupleDimensionalityHelper.assertCrossjoinDimensionality(errorContext, cache, iterables);
        }
        if (tupleFilter == null) {
            return crossjoin;
        }
        return OlapIteratorFactory.filter(crossjoin, tupleFilter.asOlapTupleIteratorFilter());
    }

    public static OlapIterator<OlapMember> childrenR(OlapMember root, @Nullable OlapLevel maxLevel, boolean withRoot) {
        return new OlapChildrenRIterator(root, maxLevel, withRoot);
    }

    public static OlapIterator<OlapMember> inverseChildrenR(OlapMember root, @Nullable OlapLevel maxLevel, boolean withRoot) {
        return new OlapChildrenRInverseIterator(root, maxLevel, withRoot);
    }

    public static OlapIterator<OlapMember> multiChildrenR(OlapMemberChildren roots) {
        if (roots.isEmpty()) {
            return OlapIteratorFactory.empty();
        }
        return new OlapMultiChildrenRIterator(roots);
    }

    public static OlapIterator<OlapTuple> reverse(OlapListTupleSet<? extends OlapTuple> tupleList) {
        return new OlapReverseIterator(tupleList);
    }
}

