/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

class OlapHeadIterator<T>
extends OlapBaseIterator<T> {
    private final OlapIterator<T> iterator;
    private final int count;
    private int pos;

    OlapHeadIterator(OlapIterator<T> iterator, int count) {
        this.iterator = iterator;
        this.count = count;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.iterator.getTupleDimensionality();
    }

    @Override
    public long fastEstimatedSize() {
        return this.count;
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.iterator.mightHaveCalcMember();
    }

    @Override
    public void reset() {
        this.iterator.reset();
        this.pos = 0;
    }

    @Override
    protected T safeNext() {
        if (this.pos >= this.count) {
            return null;
        }
        T item = this.iterator.next();
        ++this.pos;
        return item;
    }

    @Override
    public boolean _isEmpty() {
        return this.count <= 0 || this.iterator._isEmpty();
    }

    @Override
    public int _sizeSlow() {
        return Math.min(this.count, this.iterator._sizeSlow());
    }

    @Override
    public OlapHeadIterator<T> newInstance() {
        return new OlapHeadIterator<T>(this.iterator.newInstance(), this.count);
    }

    @Override
    public OlapIterator<T> head(int count) {
        return new OlapHeadIterator<T>(this.iterator.newInstance(), Math.min(this.count, count));
    }

    @Override
    public void hackForNonEmptyX() {
        this.iterator.hackForNonEmptyX();
    }
}

