/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.common.collection.CdISortedList;
import crazydev.common.collection.CdPaginatedSortedList;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCompactIterator {
    public static OlapTupleSet newInstance(OlapTupleSet<? extends OlapTuple> inputSet, boolean force) {
        OlapTuple tuple;
        OlapTupleSet quickSet = OlapCompactIterator.quickCheck(inputSet);
        if (quickSet != null) {
            return quickSet;
        }
        boolean canBeCompacted = true;
        OlapIterator inputIterator = inputSet.getIterator(false);
        Tree tree = null;
        inputIterator.reset();
        OlapMember firstMember = null;
        while ((tuple = (OlapTuple)inputIterator.next()) != null) {
            if (tree == null) {
                OlapHierarchy hierarchy;
                if (!(tuple instanceof OlapMember) || (hierarchy = ((OlapMember)tuple).getHierarchy()).getLevels().size() == 1 || !force && !hierarchy.isStandardRollup()) break;
                tree = new Tree();
            }
            OlapMember member = (OlapMember)tuple;
            OlapMember olapMember = firstMember = firstMember == null ? member : firstMember;
            if (member.canNotBeCompacted()) {
                canBeCompacted = false;
            }
            if (OlapCompactIterator.isAll(member)) {
                return OlapSetFactory.instance((OlapTuple[])new OlapMember[]{member});
            }
            if (!canBeCompacted) continue;
            tree.addMember(member);
        }
        if (tree != null && tree.memberCount == 1) {
            return OlapSetFactory.instance((OlapTuple[])new OlapMember[]{firstMember});
        }
        if (!canBeCompacted || tree == null || !tree.isCompacting() && inputIterator.isCacheUseless()) {
            return inputSet;
        }
        ArrayList<OlapMember> members = tree.asCompactList();
        return OlapSetFactory.instance(members);
    }

    private static boolean isAll(OlapMember member) {
        return member.isAll() || member.getLevel().getDepth() == 0 && member.getLevel().getMemberCount() == 1;
    }

    @Nullable
    private static OlapTupleSet quickCheck(OlapTupleSet<? extends OlapTuple> inputSet) {
        if (inputSet instanceof OlapListTupleSet) {
            OlapListTupleSet listTupleSet = (OlapListTupleSet)inputSet;
            if (listTupleSet.size() == 1) {
                return inputSet;
            }
            if (listTupleSet.size() <= 0 || !(listTupleSet.getItem(0) instanceof OlapMember)) {
                return inputSet;
            }
            OlapHierarchy hierarchy = ((OlapMember)listTupleSet.getItem(0)).getHierarchy();
            if (hierarchy.getLevels().size() == 1) {
                return inputSet;
            }
            if (hierarchy.getLevels().size() == 2 && hierarchy.getFirstLevel().getMemberCount() == 1) {
                List list = listTupleSet.getTuples();
                for (int i = 0; i < list.size(); ++i) {
                    OlapMember member = (OlapMember)list.get(i);
                    if (member.canNotBeCompacted()) {
                        return inputSet;
                    }
                    if (member.getLevel().getDepth() != 0) continue;
                    return OlapSetFactory.instance((OlapTuple[])new OlapMember[]{member});
                }
                if (list.size() < hierarchy.getLastLevel().getMemberCount()) {
                    return listTupleSet;
                }
            }
        }
        return null;
    }

    private static class Tree {
        TreeNode root = new TreeNode(null, false);
        TreeNode formerNode = null;
        int memberCount;

        private Tree() {
        }

        void addMember(OlapMember member) {
            ++this.memberCount;
            OlapMember parent = member.getParent();
            if (this.formerNode != null && OlapMember.equal(parent, this.formerNode.node)) {
                this.formerNode.addChild(member, true);
                return;
            }
            OlapMember[] branch = Tree.getBranch(member);
            this.formerNode = this.root.pushMember(branch, 0, false);
        }

        boolean isCompacting() {
            this.root.setIsPartOfList();
            return this.root.isCompacting();
        }

        ArrayList<OlapMember> asCompactList() {
            ArrayList<OlapMember> list = new ArrayList<OlapMember>();
            this.root.addToList(list);
            return list;
        }

        private static OlapMember[] getBranch(OlapMember node) {
            int depth = Tree.getBranchDepth(node);
            OlapMember[] branch = new OlapMember[depth + 1];
            while (node != null) {
                branch[Tree.getBranchDepth((OlapMember)node)] = node;
                node = node.getParent();
            }
            return branch;
        }

        private static int getBranchDepth(OlapMember node) {
            int parentDepth = 0;
            while ((node = node.getParent()) != null) {
                ++parentDepth;
            }
            return parentDepth;
        }
    }

    private static class TreeNode {
        private static final Comparator<TreeNode> treeNodeComparator = new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                return Integer.compare(o1.node.getUniqueHierarchyMemberIndex(), o2.node.getUniqueHierarchyMemberIndex());
            }
        };
        OlapMember node;
        CdISortedList<TreeNode> children = null;
        boolean isPartOfList;

        private TreeNode(OlapMember node, boolean partOfList) {
            this.node = node;
            this.isPartOfList = partOfList;
        }

        public TreeNode addChild(OlapMember member, boolean isPartOfList) {
            TreeNode treeNode;
            int pos;
            if (this.children == null) {
                this.children = new CdPaginatedSortedList(treeNodeComparator);
            }
            if ((pos = this.children.indexOf((Object)(treeNode = new TreeNode(member, isPartOfList)))) < 0) {
                this.children.add((Object)treeNode);
                return treeNode;
            }
            TreeNode existing = (TreeNode)this.children.get(pos);
            existing.isPartOfList |= isPartOfList;
            return existing;
        }

        public TreeNode pushMember(OlapMember[] branch, int pos, boolean distinct) {
            boolean isLast;
            OlapMember member = branch[pos];
            boolean bl = isLast = pos == branch.length - 1;
            if (isLast) {
                this.addChild(member, true);
                return this;
            }
            for (int i = 0; this.children != null && i < this.children.size(); ++i) {
                TreeNode treeNode = (TreeNode)this.children.get(i);
                if (!OlapMember.equal(treeNode.node, member)) continue;
                return treeNode.pushMember(branch, pos + 1, false);
            }
            return this.addChild(member, false).pushMember(branch, pos + 1, false);
        }

        public boolean setIsPartOfList() {
            if (this.isPartOfList) {
                return true;
            }
            boolean allChildrenIncluded = true;
            for (int i = 0; i < this.children.size(); ++i) {
                allChildrenIncluded &= ((TreeNode)this.children.get(i)).setIsPartOfList();
            }
            if (allChildrenIncluded && this.node != null && this.children.size() >= this.node.getChildrenCount()) {
                this.isPartOfList = true;
            }
            return this.isPartOfList;
        }

        public boolean isCompacting() {
            if (this.children == null) {
                return false;
            }
            if (this.isPartOfList && this.children.size() > 0) {
                return true;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                TreeNode treeNode = (TreeNode)this.children.get(i);
                if (!treeNode.isCompacting()) continue;
                return true;
            }
            return false;
        }

        public void addToList(ArrayList<OlapMember> members) {
            if (this.isPartOfList) {
                members.add(this.node);
            } else {
                int childrenSize = this.children == null ? -1 : this.children.size();
                for (int i = 0; i < childrenSize; ++i) {
                    ((TreeNode)this.children.get(i)).addToList(members);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TreeNode treeNode = (TreeNode)o;
            return !(this.node != null ? !this.node.equals(treeNode.node) : treeNode.node != null);
        }

        public int hashCode() {
            return this.node != null ? this.node.hashCode() : 0;
        }
    }
}

