/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.IOlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.collection.olapiterator.IOlapCombinationIterator;
import crazydev.iccube.olap.entity.result.tidy.OlapResMdxTidyTable;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.execinstr.gf.executors.GFRegularCellsExecutor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.lang.reflect.Array;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapCombinationIteratorT<T>
implements IOlapCombinationIterator<T> {
    private final Class<T> clazz;
    private final OlapResMdxTidyTable table;
    private final boolean withNonEmpty;
    private final int tidyMaxRowCount;
    private final IOlapIterator<T>[] iterators;
    @Nullable
    private final List<Integer> iteratorsPOS;
    private final int rowIteratorsCount;
    private final T[] combination;
    private final int[] Si;
    private boolean first;
    private boolean done;
    private int rowIndex;
    private int rowIndexMaxNE = -1;
    private boolean tidyMaxRowCountReached;

    public OlapCombinationIteratorT(Class<T> clazz, OlapResMdxTidyTable table, List<IOlapIterator<T>> iterators, @Nullable List<Integer> iteratorsPOS, int rowIteratorsCount) {
        this.clazz = clazz;
        this.table = table;
        this.withNonEmpty = table.isNonEmptyActive() && !table.isNonEmptyDone();
        int cellsColumnCount = table.getCellsColumnCountFromInit();
        int tidyMaxRowCount = table.getTidyMaxRowCount();
        int tidyMaxCellCount = table.getTidyMaxCellCount();
        int tidyMaxCellCountNE = table.getTidyMaxCellCountNE();
        int tidyMaxCellCountEx = this.withNonEmpty && table.getAxisCountNE() > 1 ? tidyMaxCellCountNE : tidyMaxCellCount;
        this.tidyMaxRowCount = Math.min(tidyMaxRowCount, tidyMaxCellCountEx / cellsColumnCount);
        if (!this.withNonEmpty) {
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] cell combination [max-rows:" + tidyMaxRowCount + "][max-cells:" + tidyMaxCellCountEx + "][cells-columns:" + cellsColumnCount + "] => [max-rows:" + this.tidyMaxRowCount + "]"));
        } else {
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] cell combination w/ non-empty [max-rows:" + tidyMaxRowCount + "][max-cells:" + tidyMaxCellCountEx + "][cells-columns:" + cellsColumnCount + "] => [max-rows:" + this.tidyMaxRowCount + "]"));
        }
        this.iterators = new IOlapIterator[iterators.size()];
        for (int idx = 0; idx < this.iterators.length; ++idx) {
            this.iterators[idx] = iterators.get(idx);
        }
        this.iteratorsPOS = iteratorsPOS;
        this.rowIteratorsCount = rowIteratorsCount;
        this.combination = (Object[])Array.newInstance(clazz, this.iterators.length);
        this.Si = new int[iterators.size()];
    }

    @Override
    public int axisCount() {
        return this.iterators.length;
    }

    @Override
    public List<T> extractAxis(int axis) {
        if (axis < this.iterators.length) {
            return OlapIteratorHelper.extractTuples(this.iterators[axis]);
        }
        throw new RuntimeException("internal error: inconsistent usage of cell iterator (" + axis + ")");
    }

    @Override
    public boolean isCombination() {
        return true;
    }

    @Override
    public void reset() {
        for (int idx = 0; idx < this.iterators.length - 1; ++idx) {
            IOlapIterator<T> iterator = this.iterators[idx];
            iterator.reset();
            T c = iterator.next();
            this.combination[this.iteratorPOS((int)idx)] = c;
            this.Si[this.iteratorPOS((int)idx)] = c == null ? -1 : 0;
        }
        this.iterators[this.iterators.length - 1].reset();
        this.combination[this.iteratorPOS((int)(this.iterators.length - 1))] = null;
        this.Si[this.iteratorPOS((int)(this.iterators.length - 1))] = -1;
        this.first = true;
        this.done = false;
        this.rowIndex = this.rowIteratorsCount != this.iterators.length ? 0 : -1;
        this.rowIndexMaxNE = -1;
        this.tidyMaxRowCountReached = false;
    }

    @Override
    @Nullable
    public T[] next() {
        if (this.done) {
            return null;
        }
        int current = this.iterators.length - 1;
        while (current >= 0) {
            IOlapIterator<T> iterator = this.iterators[current];
            T t = iterator.next();
            if (t != null) {
                this.combination[this.iteratorPOS((int)current)] = t;
                int n = this.iteratorPOS(current);
                this.Si[n] = this.Si[n] + 1;
                break;
            }
            if (current == 0) {
                --current;
                continue;
            }
            iterator.reset();
            T c = iterator.next();
            this.combination[this.iteratorPOS((int)current)] = c;
            int n = this.Si[this.iteratorPOS((int)current)] = c == null ? -1 : 0;
            if (this.first && c == null) break;
            --current;
        }
        if (this.first && GFRegularCellsExecutor.isEmptyCombinations(this.Si)) {
            return null;
        }
        if (this.first && this.clazz.isAssignableFrom(OlapTuple.class)) {
            this.table.assertHierarchyUsage((OlapTuple[])this.combination);
        }
        if (current >= 0 && current < this.rowIteratorsCount) {
            current = this.withNonEmpty ? this.incrementRowIndexNE(current) : this.incrementRowIndex(current);
        }
        this.first = false;
        if (current < 0) {
            this.done = true;
        }
        return current < 0 ? null : this.combination;
    }

    private int incrementRowIndexNE(int current) {
        int nonEmptyRowCount;
        if (this.rowIndexMaxNE == -1 && (nonEmptyRowCount = this.table.getRowCountNE()) >= this.tidyMaxRowCount - 1) {
            this.rowIndexMaxNE = this.rowIndex + 1;
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] cell combination w/ non-empty tidy-max-row-count marked [max:" + this.tidyMaxRowCount + "][row:" + this.rowIndex + "][row-max:" + this.rowIndexMaxNE + "]"));
        }
        if (this.rowIndexMaxNE != -1 && this.rowIndex >= this.rowIndexMaxNE) {
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] cell combination w/ non-empty tidy-max-row-count reached [max:" + this.tidyMaxRowCount + "][row:" + this.rowIndex + "]"));
            this.tidyMaxRowCountReached = true;
            current = -1;
        } else {
            ++this.rowIndex;
        }
        return current;
    }

    private int incrementRowIndex(int current) {
        if (this.rowIndex >= this.tidyMaxRowCount - 1) {
            OlapLoggers.MDX_EVALUATION.info((Object)("[mdx] cell combination tidy-max-row-count reached [max:" + this.tidyMaxRowCount + "][row:" + this.rowIndex + "]"));
            this.tidyMaxRowCountReached = true;
            current = -1;
        } else {
            ++this.rowIndex;
        }
        return current;
    }

    @Override
    public int rowIndex() {
        return this.rowIndex;
    }

    @Override
    public boolean isTidyMaxRowCountReached() {
        return this.tidyMaxRowCountReached;
    }

    @Override
    public int[] Si() {
        return this.Si;
    }

    private int iteratorPOS(int pos) {
        if (this.iteratorsPOS == null) {
            return pos;
        }
        return this.iteratorsPOS.get(pos);
    }
}

