/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.IOlapTuple;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import java.util.Iterator;
import java.util.List;

class OlapCollectionTransformIterator<T, V>
extends OlapBaseIterator<V> {
    private final OlapTupleDimensionality tupleDimensionality;
    private final List<T> collection;
    private final IOlapIteratorTransform<? super T, V> transform;
    private Iterator<T> collectionIterator;
    private boolean stop;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    OlapCollectionTransformIterator(List<T> collection, IOlapIteratorTransform<? super T, V> transform) {
        this.collection = collection;
        this.transform = transform;
        OlapTupleDimensionality tupleDimensionality = null;
        if (!this.transform.isTransformingDimensionality()) {
            Iterator<T> iterator;
            if (!collection.isEmpty() && (iterator = collection.iterator()).hasNext()) {
                T first = iterator.next();
                if (first instanceof IOlapTuple) {
                    tupleDimensionality = ((IOlapTuple)first).getTupleDimensionality();
                } else {
                    if (!(first instanceof OlapVTuple)) throw new RuntimeException("internal error: unexpected tuple [" + first.getClass().getName() + "]");
                    OlapVTuple vTuple = (OlapVTuple)first;
                    tupleDimensionality = vTuple.getTupleDimensionality();
                }
            }
        } else {
            this.reset();
            Object first = this.next();
            if (first instanceof IOlapTuple) {
                tupleDimensionality = ((OlapTuple)first).getTupleDimensionality();
            }
        }
        this.tupleDimensionality = tupleDimensionality;
    }

    @Override
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.transform.fastEstimatedSize(this.collection.size());
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (int pp = 0; pp < this.collection.size(); ++pp) {
            T member = this.collection.get(pp);
            if (!(member instanceof OlapTuple) || !((OlapTuple)member).isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.transform.reset();
        this.collectionIterator = this.collection.iterator();
        this.stop = false;
    }

    @Override
    protected V safeNext() {
        if (!this.stop) {
            while (this.collectionIterator.hasNext()) {
                T item = this.collectionIterator.next();
                if (this.transform.stop(item)) {
                    this.stop = true;
                    break;
                }
                V itemV = this.transform.transform(item);
                if (itemV == null) continue;
                return itemV;
            }
        }
        return null;
    }

    public OlapCollectionTransformIterator<T, V> newInstance() {
        return new OlapCollectionTransformIterator<T, V>(this.collection, this.transform.newInstance());
    }
}

