/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapStack;
import crazydev.iccube.collection.OlapStackInt;
import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapChildrenRIterator
extends OlapBaseIterator<OlapMember> {
    protected final OlapMember root;
    protected final boolean withRoot;
    protected final OlapStack<OlapMember> parentStack = new OlapStack();
    private final OlapStackInt childPosStack = new OlapStackInt();
    @Nullable
    protected OlapMember child;
    @Nullable
    protected OlapLevel maxLevel;
    private boolean firstDelivered;

    public OlapChildrenRIterator(OlapMember root, @Nullable OlapLevel maxLevel, boolean withRoot) {
        this.maxLevel = maxLevel;
        this.root = root;
        this.withRoot = withRoot;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.root.getTupleDimensionality();
    }

    @Override
    public long fastEstimatedSize() {
        return this.root.getDescendantsCount();
    }

    @Override
    public boolean mightHaveCalcMember() {
        return this.withRoot && this.root.isCalculated();
    }

    @Override
    public boolean isMemberIterator() {
        return true;
    }

    @Override
    public boolean isMembersCrossjoin() {
        return true;
    }

    @Override
    public void reset() {
        this.parentStack.clear();
        this.childPosStack.clear();
        this.firstDelivered = false;
    }

    @Override
    @Nullable
    protected OlapMember safeNext() {
        if (!this.firstDelivered) {
            return this.handleFirst();
        }
        if (this.child == null) {
            return null;
        }
        this.child = this.doNext();
        return this.child;
    }

    @Nullable
    private OlapMember handleFirst() {
        this.firstDelivered = true;
        if (!this.withRoot) {
            this.child = this.root;
            this.child = this.doNext();
        } else {
            this.child = this.isOutOfMaxLevel(this.root) ? null : this.root;
        }
        return this.child;
    }

    public OlapChildrenRIterator newInstance() {
        return new OlapChildrenRIterator(this.root, this.maxLevel, this.withRoot);
    }

    @Nullable
    private OlapMember doNext() {
        OlapMember xchild = this.getChild();
        if (xchild != null) {
            return xchild;
        }
        xchild = this.getBrother();
        if (xchild != null) {
            return xchild;
        }
        while (!this.parentStack.isEmpty() && !OlapMember.equal(this.parentStack.pop(), this.root)) {
            this.popChildPos();
            xchild = this.getBrother();
            if (xchild == null) continue;
            return xchild;
        }
        return null;
    }

    @Nullable
    protected OlapMember getChild() {
        if (this.child.isLeaf()) {
            return null;
        }
        int childrenCount = this.child.getChildrenCount();
        for (int pos = 0; pos < childrenCount; ++pos) {
            OlapMember xchild = this.child.getChild(pos);
            if (this.isOutOfMaxLevel(xchild)) continue;
            this.pushParent(this.child);
            this.pushChildPos(pos);
            return xchild;
        }
        return null;
    }

    @Nullable
    protected OlapMember getBrother() {
        if (!this.parentStack.isEmpty()) {
            OlapMember parent = this.peekParent();
            if (parent == null) {
                boolean bl = false;
            }
            int childPos = this.peekChildPos();
            for (int xChildPos = childPos + 1; xChildPos < parent.getChildrenCount(); ++xChildPos) {
                OlapMember member = parent.getChild(xChildPos);
                if (this.isOutOfMaxLevel(member)) continue;
                this.popAndPushChildPos(xChildPos);
                return member;
            }
        }
        return null;
    }

    protected boolean isOutOfMaxLevel(OlapMember member) {
        return this.maxLevel != null && this.maxLevel.getDepth() < member.getLevel().getDepth();
    }

    protected void pushParent(OlapMember member) {
        this.parentStack.push(member);
    }

    protected OlapMember peekParent() {
        return this.parentStack.peek();
    }

    protected void pushChildPos(int pos) {
        this.childPosStack.push(pos);
    }

    protected void popAndPushChildPos(int pos) {
        this.childPosStack.replace(pos);
    }

    private int popChildPos() {
        return this.childPosStack.pop();
    }

    protected int peekChildPos() {
        return this.childPosStack.peek();
    }
}

