/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorHelper;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.request.request.IcCubeRequest;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class OlapBaseIterator<T>
implements OlapIterator<T> {
    @Override
    public boolean isCrossjoin() {
        return false;
    }

    @Override
    public long fastEstimatedSize() {
        return -1L;
    }

    @Override
    @Nullable
    public List<OlapMember> tryExtractMeasures(OlapHierarchy measureHierarchy) {
        OlapTupleDimensionality thisTupleDimensionality = this.getTupleDimensionality();
        if (thisTupleDimensionality == null) {
            return null;
        }
        if (!thisTupleDimensionality.intersects(measureHierarchy.getTupleDimensionality())) {
            return Collections.emptyList();
        }
        if (thisTupleDimensionality.cardinality() == 1) {
            List<OlapMember> tuples = OlapIteratorHelper.extractTuplesForMeasures(this);
            return tuples;
        }
        if (this.tryExtractMeasuresOnTuples()) {
            List<OlapMember> tuples = OlapIteratorHelper.extractTuplesForMeasures(this).stream().map(t -> t.getMember(measureHierarchy)).toList();
            return tuples;
        }
        return null;
    }

    protected boolean tryExtractMeasuresOnTuples() {
        return false;
    }

    @Override
    public boolean _isEmpty() {
        this.reset();
        return this.next() == null;
    }

    @Override
    public int _sizeSlow() {
        int count = 0;
        this.reset();
        while (this.next() != null) {
            ++count;
        }
        return count;
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        T member;
        int count = 0;
        this.reset();
        while ((member = this.next()) != null) {
            if (count == index) {
                return member;
            }
            ++count;
        }
        return null;
    }

    @Override
    public boolean isMemberIterator() {
        OlapTupleDimensionality tupleDimensionality = this.getTupleDimensionality();
        if (tupleDimensionality != null) {
            return tupleDimensionality.cardinality() == 1;
        }
        this.reset();
        T firstItem = this.next();
        return firstItem == null || firstItem instanceof OlapMember;
    }

    @Override
    public boolean isMembersCrossjoin() {
        return false;
    }

    @Override
    public boolean isCacheUseless() {
        return false;
    }

    @Override
    @Nullable
    public final T next() {
        IcCubeRequest.assertNotCancelled("set-iteration");
        return this.safeNext();
    }

    @Nullable
    protected abstract T safeNext();

    @Override
    public List<List<T>> asCrossjoinMaterializedTuples() {
        return OlapIterator.asCrossjoinMaterializedTuples(this);
    }
}

