/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection.olapiterator;

import crazydev.iccube.collection.olapiterator.OlapBaseIterator;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import org.jetbrains.annotations.Nullable;

public class OlapArrayIterator<T>
extends OlapBaseIterator<T> {
    @Nullable
    private final OlapTupleDimensionality tupleDimensionality;
    private final T[] items;
    private final int len;
    private int pos;

    public OlapArrayIterator(T ... items) {
        this(items, items.length);
    }

    OlapArrayIterator(T[] items, int len) {
        this.items = items;
        this.len = len;
        this.tupleDimensionality = this.len == 0 ? null : (this.items[0] instanceof OlapTuple ? ((OlapTuple)this.items[0]).getTupleDimensionality() : null);
    }

    @Override
    protected boolean tryExtractMeasuresOnTuples() {
        return true;
    }

    @Override
    @Nullable
    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tupleDimensionality;
    }

    @Override
    public long fastEstimatedSize() {
        return this.len;
    }

    @Override
    public boolean mightHaveCalcMember() {
        for (int pp = 0; pp < this.items.length; ++pp) {
            T member = this.items[pp];
            if (!(member instanceof OlapTuple) || !((OlapTuple)member).isCalculated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.pos = 0;
    }

    @Override
    protected T safeNext() {
        return this.pos < this.len ? (T)this.items[this.pos++] : null;
    }

    @Override
    public boolean _isEmpty() {
        return this.items.length == 0 || this.len == 0 || this.items[0] == null;
    }

    @Override
    public int _sizeSlow() {
        return this.items.length;
    }

    @Override
    @Nullable
    public T _getSlow(int index) {
        return index < this.items.length ? (T)this.items[index] : null;
    }

    @Override
    public OlapArrayIterator<T> newInstance() {
        return new OlapArrayIterator<T>(this.items, this.len);
    }

    @Override
    public boolean isCacheUseless() {
        return true;
    }
}

