/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.exception.programming.CdDoNotCallMeProgrammingException;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.operator.scalar.OlapScalarOperators;
import java.util.Comparator;

public class OlapVTuple<T extends OlapScalarEntity> {
    public static final Comparator<OlapVTuple<OlapNumericEntity>> NUMERICAL_ASC_COMPARATOR = new Comparator<OlapVTuple<OlapNumericEntity>>(){

        @Override
        public int compare(OlapVTuple<OlapNumericEntity> o1, OlapVTuple<OlapNumericEntity> o2) {
            int cmp = Double.compare(((OlapNumericEntity)o1.value).value(), ((OlapNumericEntity)o2.value).value());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(o1.pos, o2.pos);
        }
    };
    public static final Comparator<OlapVTuple<OlapNumericEntity>> NUMERICAL_DESC_COMPARATOR = new Comparator<OlapVTuple<OlapNumericEntity>>(){

        @Override
        public int compare(OlapVTuple<OlapNumericEntity> o1, OlapVTuple<OlapNumericEntity> o2) {
            int cmp = Double.compare(((OlapNumericEntity)o2.value).value(), ((OlapNumericEntity)o1.value).value());
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(o1.pos, o2.pos);
        }
    };
    public final OlapTuple tuple;
    public final T value;
    private final int pos;

    public OlapVTuple(OlapTuple tuple, T value, int pos) {
        this.tuple = tuple;
        this.value = value;
        this.pos = pos;
    }

    public static final Comparator<OlapVTuple<OlapScalarEntity>> DESC_COMPARATOR(Comparator<String> stringComparator) {
        return (o1, o2) -> {
            int cmp = OlapScalarOperators.compare(stringComparator, o2.value, o1.value);
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(o1.pos, o2.pos);
        };
    }

    public static final Comparator<OlapVTuple<OlapScalarEntity>> RAW_ASC_COMPARATOR(Comparator<String> stringComparator) {
        return (o1, o2) -> {
            int cmp = OlapScalarOperators.compare(stringComparator, o1.value, o2.value);
            return cmp;
        };
    }

    public static final Comparator<OlapVTuple<OlapScalarEntity>> RAW_DESC_COMPARATOR(Comparator<String> stringComparator) {
        return (o1, o2) -> {
            int cmp = OlapScalarOperators.compare(stringComparator, o2.value, o1.value);
            return cmp;
        };
    }

    public static Comparator<OlapVTuple<OlapScalarEntity>> ASC_COMPARATOR(Comparator<String> stringComparator) {
        return (o1, o2) -> {
            int cmp = OlapScalarOperators.compare(stringComparator, o1.value, o2.value);
            if (cmp != 0) {
                return cmp;
            }
            return Integer.compare(o1.pos, o2.pos);
        };
    }

    public int getPos() {
        return this.pos;
    }

    public OlapTupleDimensionality getTupleDimensionality() {
        return this.tuple.getTupleDimensionality();
    }

    public final boolean equals(Object o) {
        throw new CdDoNotCallMeProgrammingException();
    }

    public final int hashCode() {
        throw new CdDoNotCallMeProgrammingException();
    }

    public int getMemberCount() {
        return this.tuple.getMemberCount();
    }

    public OlapMember getMember(int idx) {
        return this.tuple.getMember(idx);
    }

    public String toString() {
        return this.tuple.toString() + ":" + String.valueOf(this.value);
    }
}

