/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.iccube.olap.eval.lambda.IOlapLambdaProcessingEnabled;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

public class OlapStack<E> {
    private Object[] elements;
    private int head;
    private int tail;

    public OlapStack() {
        this.elements = new Object[16];
    }

    private OlapStack(Object[] elements, int head, int tail) {
        this.elements = elements;
        this.head = head;
        this.tail = tail;
    }

    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public void clear() {
        int h = this.head;
        int t = this.tail;
        if (h != t) {
            this.tail = 0;
            this.head = 0;
            int i = h;
            int mask = this.elements.length - 1;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != t);
        }
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = a;
        this.head = 0;
        this.tail = n;
    }

    public void addLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
    }

    public void push(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.head = this.head - 1 & this.elements.length - 1;
        this.elements[this.head] = e;
        if (this.head == this.tail) {
            this.doubleCapacity();
        }
    }

    public E pop() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    private E pollFirst() {
        int h = this.head;
        Object result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.elements.length - 1;
        return (E)result;
    }

    public E peek() {
        return (E)this.elements[this.head];
    }

    @Nullable
    public E mark() {
        return !this.isEmpty() ? (E)this.peek() : null;
    }

    public void resetToMark(@Nullable E mark) {
        E item;
        while (!this.isEmpty() && (item = this.peek()) != mark) {
            this.pop();
        }
    }

    @Nullable
    public OlapStack<E> save() {
        if (this.isEmpty()) {
            return null;
        }
        Object[] elements_ = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, elements_, 0, this.elements.length);
        return new OlapStack<E>(elements_, this.head, this.tail);
    }

    public OlapStack<E> saveEx() {
        Object[] elements_ = new Object[this.elements.length];
        System.arraycopy(this.elements, 0, elements_, 0, this.elements.length);
        return new OlapStack<E>(elements_, this.head, this.tail);
    }

    public void restore(OlapStack<E> items) {
        this.elements = new Object[items.elements.length];
        System.arraycopy(items.elements, 0, this.elements, 0, items.elements.length);
        this.head = items.head;
        this.tail = items.tail;
    }

    public boolean containsRef(E obj) {
        int cursor = this.head;
        int fence = this.tail;
        while (cursor != fence) {
            Object result = this.elements[cursor];
            if (this.tail != fence || result == null) {
                throw new ConcurrentModificationException();
            }
            cursor = cursor + 1 & this.elements.length - 1;
            if (obj != result) continue;
            return true;
        }
        return false;
    }

    public boolean forEachItem(ItemProcessor<E> processor) {
        if (processor != null) {
            int count = this.size();
            int index = 0;
            Object prev = null;
            int cursor = this.head;
            int fence = this.tail;
            while (cursor != fence) {
                Object result = this.elements[cursor];
                if (this.tail != fence || result == null) {
                    throw new ConcurrentModificationException();
                }
                cursor = cursor + 1 & this.elements.length - 1;
                if (!processor.process(prev, result, count, index++)) {
                    return false;
                }
                prev = result;
            }
        }
        return true;
    }

    public boolean process(Processor<E> processor) {
        if (processor != null) {
            int cursor = this.head;
            int fence = this.tail;
            while (cursor != fence) {
                Object result = this.elements[cursor];
                if (this.tail != fence || result == null) {
                    throw new ConcurrentModificationException();
                }
                cursor = cursor + 1 & this.elements.length - 1;
                if (processor.process(result)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processB(Processor<E> processor) {
        if (processor != null) {
            int cursor = this.head;
            int fence = this.tail;
            while (cursor != fence) {
                Object result = this.elements[cursor];
                if (this.tail != fence || result == null) {
                    throw new ConcurrentModificationException();
                }
                cursor = cursor + 1 & this.elements.length - 1;
                if (!processor.process(result)) continue;
                return true;
            }
        }
        return false;
    }

    public void setupForParallelLambdaProcessing(OlapStack<E> from) {
        if (!this.isEmpty()) {
            throw new RuntimeException("internal error: inconsistent parallel lambda processing setup");
        }
        if (from.isEmpty()) {
            return;
        }
        from.process(item -> {
            if (item instanceof IOlapLambdaProcessingEnabled) {
                Object duplicate = ((IOlapLambdaProcessingEnabled)item).forkForParallelLambdaProcessing();
                this.addLast(duplicate);
                return true;
            }
            throw new RuntimeException("internal error: inconsistent parallel lambda processing setup : " + String.valueOf(item != null ? item.getClass() : ""));
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.process(item -> {
            sb.append(item).append(",");
            return true;
        });
        return sb.toString();
    }

    public static interface ItemProcessor<E> {
        public boolean process(@Nullable E var1, E var2, int var3, int var4);
    }

    public static interface Processor<E> {
        public boolean process(E var1);
    }
}

