/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.collection.CdISortedList;
import crazydev.common.collection.CdPaginatedSortedList;
import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.collection.IOlapSortedVTuples;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapIteratorTransform;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public abstract class OlapSortedVTuples<T extends OlapScalarEntity>
implements IOlapSortedVTuples<T> {
    private final OlapErrorLocation locationRange;
    private final String functionName;
    private final int internalTupleListCount;
    protected final CdISortedList<OlapVTuple<T>> valuedTuples;

    protected OlapSortedVTuples(OlapErrorLocation locationRange, String functionName, int internalTupleListCount, Comparator<OlapVTuple<T>> comparator) {
        this.locationRange = locationRange;
        this.functionName = functionName;
        this.internalTupleListCount = internalTupleListCount;
        this.valuedTuples = new CdPaginatedSortedList(comparator);
    }

    protected void assertHardLimit() {
        if (this.valuedTuples.size() > this.internalTupleListCount) {
            throw new OlapEvaluationException(this.locationRange, OlapErrorCode.TUPLE_LIST_COUNT, new Serializable[]{this.functionName, Integer.valueOf(this.internalTupleListCount)});
        }
    }

    public void addTo(List<OlapTuple> tuples) {
        for (OlapVTuple valuedTuple : this.valuedTuples) {
            tuples.add(valuedTuple.tuple);
        }
    }

    @Override
    public OlapTupleSet<OlapTuple> asSet() {
        OlapIterator<OlapTuple> xiterator = OlapIteratorFactory.transform(this.valuedTuples, new MyTransform());
        return OlapSetFactory.instance(xiterator);
    }

    private static class MyTransform
    extends OlapIteratorTransform<OlapVTuple, OlapTuple> {
        private MyTransform() {
        }

        @Override
        public boolean isTransformingDimensionality() {
            return false;
        }

        @Override
        public long fastEstimatedSize(long originalCollectionSize) {
            return originalCollectionSize;
        }

        @Override
        public OlapTuple transform(OlapVTuple olapVTuple) {
            return olapVTuple.tuple;
        }

        @Override
        public IOlapIteratorTransform<OlapVTuple, OlapTuple> newInstance() {
            return this;
        }
    }
}

