/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.iccube.collection.IOlapIteratorTransform;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.collection.OlapSortedNumericTuples;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.collection.olapiterator.OlapIteratorFactory;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.Comparator;

public abstract class OlapPercentBoundedSortedVTuples
extends OlapSortedNumericTuples {
    private final double percentage;
    private double sum;

    public OlapPercentBoundedSortedVTuples(OlapErrorLocation locationRange, String functionName, int internalTupleListCount, Comparator<OlapVTuple<OlapNumericEntity>> comparator, double percentage, boolean excludeEmpty) {
        super(locationRange, functionName, internalTupleListCount, comparator, excludeEmpty);
        this.percentage = percentage;
    }

    @Override
    public void add(OlapTuple tuple, OlapNumericEntity value, int pos) {
        OlapVTuple<OlapNumericEntity> valuedTuple = new OlapVTuple<OlapNumericEntity>(tuple, value, pos);
        this.valuedTuples.add(valuedTuple);
        this.sum += value.value();
        this.assertHardLimit();
    }

    @Override
    public OlapTupleSet<OlapTuple> asSet() {
        double percentageSum = this.sum * this.percentage / 100.0;
        MyTransform transform = new MyTransform(percentageSum);
        OlapIterator<OlapTuple> xiterator = OlapIteratorFactory.transform(this.valuedTuples, transform);
        return OlapSetFactory.instance(xiterator);
    }

    private static class MyTransform
    implements IOlapIteratorTransform<OlapVTuple<OlapNumericEntity>, OlapTuple> {
        private final double percentageSum;
        private boolean hasReturnedOneAtLeast;
        private double sum;

        public MyTransform(double percentageSum) {
            this.percentageSum = percentageSum;
            this.reset();
        }

        @Override
        public boolean isTransformingDimensionality() {
            return false;
        }

        @Override
        public long fastEstimatedSize(long originalCollectionSize) {
            return originalCollectionSize;
        }

        @Override
        public void reset() {
            this.hasReturnedOneAtLeast = false;
            this.sum = 0.0;
        }

        @Override
        public OlapTuple transform(OlapVTuple<OlapNumericEntity> top) {
            this.sum += ((OlapNumericEntity)top.value).value();
            return top.tuple;
        }

        @Override
        public boolean stop(OlapVTuple<OlapNumericEntity> olapTuple) {
            if (!this.hasReturnedOneAtLeast) {
                this.hasReturnedOneAtLeast = true;
                return false;
            }
            return this.sum >= this.percentageSum;
        }

        @Override
        public IOlapIteratorTransform<OlapVTuple<OlapNumericEntity>, OlapTuple> newInstance() {
            return new MyTransform(this.percentageSum);
        }
    }
}

