/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.collection.CdOnErrorCollection;
import crazydev.iccube.collection.OlapDistinctTupleSet;
import crazydev.iccube.collection.OlapIterator;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.entity.tuple.OlapTuple;

public class OlapLazyDistinctCollection<T extends OlapTuple>
extends CdOnErrorCollection<T> {
    private final OlapDistinctTupleSet<T> distincts = new OlapDistinctTupleSet();
    private final OlapIterator<T> underlying;
    private boolean endReached = false;

    public OlapLazyDistinctCollection(OlapTupleSet<T> underlying) {
        this.underlying = underlying.getIterator(false);
        this.underlying.reset();
    }

    public OlapLazyDistinctCollection(OlapIterator<T> underlying, T firstUnderlyingTuple) {
        this.underlying = underlying;
        this.addToDistincts(firstUnderlyingTuple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        boolean contains = this.distincts.contains((OlapTuple)o);
        if (contains || this.endReached) {
            return contains;
        }
        OlapIterator<T> olapIterator = this.underlying;
        synchronized (olapIterator) {
            OlapTuple item;
            while (!this.endReached && (item = (OlapTuple)this.underlying.next()) != null) {
                this.addToDistincts(item);
                if (!item.equals(o)) continue;
                return true;
            }
            this.endReached = true;
            return false;
        }
    }

    protected void addToDistincts(T item) {
        this.distincts.add(item);
    }
}

