/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.collection.CdArrayList;
import crazydev.iccube.collection.OlapITuple;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.set.OlapListTupleSet;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import crazydev.iccube.olap.eval.exception.OlapEvaluationException;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class OlapITupleList {
    protected final CdArrayList<OlapITuple> iTuples = new CdArrayList();
    private final OlapErrorLocation locationRange;
    private final String functionName;
    private final int internalTupleListCount;
    protected final int limit;

    public OlapITupleList(OlapErrorLocation locationRange, String functionName, int internalTupleListCount, int limit) {
        this.locationRange = locationRange;
        this.functionName = functionName;
        this.internalTupleListCount = internalTupleListCount;
        this.limit = limit;
    }

    public int limit() {
        return this.limit;
    }

    protected void assertHardLimit() {
        if (this.iTuples.size() >= this.internalTupleListCount) {
            throw new OlapEvaluationException(this.locationRange, OlapErrorCode.TUPLE_LIST_COUNT, new Serializable[]{this.functionName, Integer.valueOf(this.internalTupleListCount)});
        }
    }

    public abstract int stopIterationOrdinal();

    public abstract void add(OlapITuple var1);

    public OlapListTupleSet<OlapTuple> sort(boolean sort) {
        if (sort) {
            this.iTuples.parallelSort(OlapITuple.ASC_COMPARATOR);
        }
        ArrayList<OlapTuple> tuples = new ArrayList<OlapTuple>(this.iTuples.size());
        for (OlapITuple iTuple : this.iTuples) {
            tuples.add(iTuple.getTuple());
        }
        return OlapSetFactory.instance(tuples).limit(this.limit);
    }

    public int size() {
        return this.iTuples.size();
    }
}

