/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.collection;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.collection.OlapSortedScalarTuples;
import crazydev.iccube.collection.OlapVTuple;
import crazydev.iccube.exception.OlapErrorLocation;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.OlapTuple;
import java.util.Comparator;

public abstract class OlapCountBoundedSortedVTuples
extends OlapSortedScalarTuples {
    private final int count;
    private final boolean excludeEmpty;

    public OlapCountBoundedSortedVTuples(OlapErrorLocation locationRange, String functionName, int internalTupleListCount, Comparator<OlapVTuple<OlapScalarEntity>> comparator, int count, boolean excludeEmpty) {
        super(locationRange, functionName, internalTupleListCount, comparator, excludeEmpty);
        this.count = count;
        this.excludeEmpty = excludeEmpty;
    }

    @Override
    public void addEmpty(OlapTuple tuple, int pos) {
        if (!this.excludeEmpty) {
            super.addEmpty(tuple, pos);
        }
    }

    @Override
    public void add(OlapTuple tuple, OlapScalarEntity value, int pos) {
        this.valuedTuples.add(new OlapVTuple<OlapScalarEntity>(tuple, value, pos));
        while (this.valuedTuples.size() > this.count) {
            if (this.valuedTuples.removeLastItem()) continue;
            throw new CdProgrammingException("Infinite loop!");
        }
        this.assertHardLimit();
    }
}

