/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.type.DistinctCountOptimType;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_DimensionDef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDef;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class S_SchemaDef {
    private final S_SchemaRef ref;
    private final String name;
    private final List<S_DimensionDef> dimensions = new ArrayList<S_DimensionDef>();
    private final Map<S_CubeRef, S_CubeDef> cubes = new HashMap<S_CubeRef, S_CubeDef>();
    private final boolean incrLoadActive;
    private final boolean factPartitioningActive;
    private final DistinctCountOptimType distinctCountOptimType;
    private final IOlapFactListFactory factsColumnListFactory;
    private final S_FactBitmapContainerFactory factsBitmapContainerFactory;
    private Map<Integer, Integer> hierarchyIndexToBaseHierarchyIndices;
    private boolean enableReverseLink;

    public S_SchemaDef(S_SchemaRef ref, String name, boolean incrLoadActive, boolean factPartitioningActive, DistinctCountOptimType distinctCountOptimType, IOlapFactListFactory factsColumnListFactory, S_FactBitmapContainerFactory factsBitmapContainerFactory, boolean enableReverseLink) {
        this.ref = ref;
        this.ref.setReferenced(this);
        this.name = name;
        this.enableReverseLink = enableReverseLink;
        this.incrLoadActive = incrLoadActive;
        this.factPartitioningActive = factPartitioningActive;
        this.distinctCountOptimType = distinctCountOptimType;
        this.factsColumnListFactory = factsColumnListFactory;
        this.factsBitmapContainerFactory = factsBitmapContainerFactory;
        this.hierarchyIndexToBaseHierarchyIndices = new HashMap<Integer, Integer>();
    }

    public boolean enableReverseLink() {
        return this.enableReverseLink;
    }

    public S_SchemaRef getRef() {
        return this.ref;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncrLoadActive() {
        return this.incrLoadActive;
    }

    public boolean isFactPartitioningActive() {
        return this.factPartitioningActive;
    }

    public DistinctCountOptimType getDistinctCountOptimType() {
        return this.distinctCountOptimType;
    }

    public Collection<S_CubeDef> getAllCubes() {
        return this.cubes.values();
    }

    public void addDimension(S_DimensionDef dimension) {
        this.dimensions.add(dimension);
    }

    public void setHierarchyIndexToBaseHierarchyIndices(Map<Integer, Integer> hierarchyIndexToBaseHierarchyIndices) {
        this.hierarchyIndexToBaseHierarchyIndices = hierarchyIndexToBaseHierarchyIndices;
    }

    @Nullable
    public Integer getBaseHierarchyIndex(int index) {
        return this.hierarchyIndexToBaseHierarchyIndices.get(index);
    }

    public void resizeDimension(N_BuildSchemaContext context, S_IncrLoadDimensionUpdateDef update) {
        for (int ii = 0; ii < update.size(); ++ii) {
            int hierarchyIdx = update.getHierarchyIdx(ii);
            int hierarchyMaxMemberIdx = update.getHierarchyMaxMemberIndex(ii);
            S_HierarchyDef hierarchyDef = this.lookupHierarchy(hierarchyIdx);
            if (hierarchyDef == null) continue;
            hierarchyDef.resize(context, hierarchyMaxMemberIdx);
        }
    }

    public S_DimensionDef getDimension(String dimensionName) {
        for (S_DimensionDef dimension : this.dimensions) {
            if (!dimension.getName().equals(dimensionName)) continue;
            return dimension;
        }
        throw new RuntimeException("internal error: [" + this.getName() + "] missing dimension [" + dimensionName + "]");
    }

    public void addCube(S_CubeDef cube) {
        this.cubes.put(cube.getRef(), cube);
    }

    public S_CubeDef resolveCube(S_CubeRef cubeRef) {
        Object referenced = cubeRef.getReferenced();
        if (referenced != null) {
            return (S_CubeDef)referenced;
        }
        S_CubeDef cube = this.cubes.get(cubeRef);
        if (cube != null) {
            return cube;
        }
        throw new RuntimeException("internal error: [" + this.getName() + "] missing cube [" + String.valueOf(cubeRef) + "]");
    }

    public S_CubeDef resolveCube(String cube) {
        for (S_CubeDef cubeDef : this.cubes.values()) {
            if (!cubeDef.getName().equals(cube)) continue;
            return cubeDef;
        }
        throw new RuntimeException("internal error: [" + this.getName() + "] missing cube [" + cube + "]");
    }

    public int getIndexingHierarchyArraySize() {
        return this.getMaxIndexingHierarchyIndex() + 1;
    }

    private int getMaxIndexingHierarchyIndex() {
        int max = 0;
        for (S_DimensionDef dimension : this.dimensions) {
            for (S_HierarchyDef hierarchy : dimension.getHierarchies()) {
                int index = hierarchy.getTupleDimensionalityIndex();
                max = Math.max(max, index);
            }
        }
        return max;
    }

    public S_HierarchyDef getHierarchy(int hierarchyIdx) {
        S_HierarchyDef hierarchy = this.lookupHierarchy(hierarchyIdx);
        if (hierarchy == null) {
            throw new RuntimeException("internal error: [" + this.getName() + "] missing hierarchy [" + hierarchyIdx + "]");
        }
        return hierarchy;
    }

    @Nullable
    public S_HierarchyDef lookupHierarchy(int hierarchyIdx) {
        for (S_DimensionDef dimension : this.dimensions) {
            for (S_HierarchyDef hierarchyDef : dimension.getHierarchies()) {
                if (hierarchyDef.getTupleDimensionalityIndex() != hierarchyIdx) continue;
                return hierarchyDef;
            }
        }
        return null;
    }

    @Nullable
    public String lookupHierarchyName(int hierarchyIdx) {
        S_HierarchyDef h = this.lookupHierarchy(hierarchyIdx);
        return h != null ? h.getName() : null;
    }

    public IOlapFactListFactory getFactsColumnListFactory() {
        return this.factsColumnListFactory;
    }

    public S_FactBitmapContainerFactory getFactsBitmapContainerFactory() {
        return this.factsBitmapContainerFactory;
    }
}

