/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class S_NonEmptyBehaviorNode {
    private final OlapFactMeasureGroupBaseManager measureGroupRef;
    private final List<OlapMeasureMember> measures;

    public S_NonEmptyBehaviorNode(OlapFactMeasureGroupBaseManager measureGroupRef) {
        this(measureGroupRef, (OlapMeasureMember)null);
    }

    public S_NonEmptyBehaviorNode(OlapFactMeasureGroupBaseManager measureGroupRef, @Nullable OlapMeasureMember measure) {
        this.measureGroupRef = measureGroupRef;
        this.measures = measure != null ? Arrays.asList(measure) : Collections.emptyList();
        this.measures.sort(Comparator.comparing(OlapMember::getNameX));
    }

    public S_NonEmptyBehaviorNode(OlapFactMeasureGroupBaseManager measureGroupRef, @Nullable List<OlapMeasureMember> measures) {
        this.measureGroupRef = measureGroupRef;
        this.measures = measures;
        this.measures.sort(Comparator.comparing(OlapMember::getNameX));
    }

    public OlapFactMeasureGroupBaseManager getMeasureGroupRef() {
        return this.measureGroupRef;
    }

    public List<OlapMeasureMember> getMeasures() {
        return this.measures;
    }

    public boolean hasAggregationWithRollupHierarchy(@Nullable Logger logger, @Nullable String prefix) {
        for (OlapMeasureMember measure : this.measures) {
            OlapAggregationType aggregation = measure.getHierarchyAggregationType();
            if (!aggregation.isRollupHierarchyRequired()) continue;
            if (logger != null) {
                logger.info((Object)(prefix + "measure [" + measure.getNameX() + "] w/ aggregation w/ rollup hierarchy [" + aggregation.getFriendlyName() + "]"));
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.measureGroupRef.getMeasureGroupName();
    }
}

