/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderMeasureDef;
import crazydev.iccube.builder.type.OlapBuilderColumnDecorationType;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.enums.OlapAggregationType;
import org.jetbrains.annotations.Nullable;

public class S_MeasureColumn {
    private final IOlapBuilderMeasureDef measureDef;
    private final int measureDefIndex;
    private final IOlapBuilderDataColumnDef column;
    private final OlapAggregationType hierarchyAggregationType;
    private final OlapBuilderInputType cubeDataType;
    @Nullable
    private final OlapBuilderColumnDecorationType cubeDataTypeDecoration;

    public S_MeasureColumn(IOlapBuilderMeasureDef measureDef, int measureDefIndex) {
        this.measureDef = measureDef;
        this.measureDefIndex = measureDefIndex;
        this.column = measureDef.getColumn();
        this.hierarchyAggregationType = measureDef.getAggregationType();
        this.cubeDataType = measureDef.getFactDataType();
        this.cubeDataTypeDecoration = measureDef.getFactDataTypeDecoration();
    }

    public int getFactsColumnIndex() {
        return this.measureDefIndex;
    }

    public String getFactsColumnName() {
        return this.column.getName();
    }

    public boolean isOkForMeasure(IOlapBuilderMeasureDef otherMeasureDef) {
        IOlapBuilderDataColumnDef otherColumn = otherMeasureDef.getColumn();
        if (!this.column.equals(otherColumn)) {
            return false;
        }
        OlapAggregationType otherHierarchyAggregationType = otherMeasureDef.getAggregationType();
        if (this.hierarchyAggregationType == OlapAggregationType.DISTINCT_COUNT || otherHierarchyAggregationType == OlapAggregationType.DISTINCT_COUNT) {
            return this.hierarchyAggregationType == otherHierarchyAggregationType && this.isSameDataType(otherMeasureDef);
        }
        if (this.hierarchyAggregationType == OlapAggregationType.COUNT || otherHierarchyAggregationType == OlapAggregationType.COUNT) {
            return this.hierarchyAggregationType == otherHierarchyAggregationType && this.isSameDataType(otherMeasureDef);
        }
        return this.isSameDataType(otherMeasureDef);
    }

    private boolean isSameDataType(IOlapBuilderMeasureDef otherMeasureDef) {
        OlapBuilderInputType otherCubeDataType = otherMeasureDef.getFactDataType();
        OlapBuilderColumnDecorationType otherCubeDataTypeDecoration = otherMeasureDef.getFactDataTypeDecoration();
        return this.cubeDataType == otherCubeDataType && this.cubeDataTypeDecoration == otherCubeDataTypeDecoration;
    }
}

