/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.cluster.shared.schema.S_FactMemberDefIndices;
import crazydev.iccube.cluster.shared.schema.S_FactMemberInfo;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_MemberDefType;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.entity.member.OlapAbstractCategoryMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.tuple.IOlapMembers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class S_FactTupleDef_
implements S_FactTupleDef {
    public final String[] __debug_NAME;
    private final S_TupleDimensionalityDef dimensionality;
    private final boolean invalid;
    private final boolean filteredOut;
    private final List<Integer> standardIndices;
    private final List<OlapHierarchyScope> categoryScopes;
    private final List<Long> categoryCacheIds;
    private final List<Integer> categoryIndices;
    private final boolean isMeasure;

    public S_FactTupleDef_(IOlapMembers tuple) {
        this.invalid = tuple.isInvalid();
        this.filteredOut = tuple.isFilteredOut();
        HashSet<OlapMember> fStandards = new HashSet<OlapMember>();
        HashSet<OlapMember> fCategories = new HashSet<OlapMember>();
        this.standardIndices = new ArrayList<Integer>();
        this.isMeasure = tuple.isMeasure();
        this.categoryScopes = new ArrayList<OlapHierarchyScope>();
        this.categoryCacheIds = new ArrayList<Long>();
        this.categoryIndices = new ArrayList<Integer>();
        for (int ii = 0; ii < tuple.getMemberCount(); ++ii) {
            OlapMember member = tuple.getMember(ii);
            OlapMember fMember = member.getFactIndexingMember();
            S_MemberDefType fMemberType = S_MemberDefType.memberType(fMember);
            if (fMemberType.isStandard()) {
                if (fStandards.contains(fMember)) continue;
                fStandards.add(fMember);
                this.standardIndices.add(member.getHierarchy().getTupleDimensionalityIndex());
                this.standardIndices.add(fMember.getHierarchy().getTupleDimensionalityIndex());
                this.standardIndices.add(fMember.getUniqueHierarchyMemberIndex());
                continue;
            }
            if (!fMemberType.isCategory() || fCategories.contains(fMember)) continue;
            fCategories.add(fMember);
            this.categoryScopes.add(((OlapAbstractCategoryMember)fMember).getScope());
            this.categoryCacheIds.add(((OlapAbstractCategoryMember)fMember).getCacheId());
            this.categoryIndices.add(member.getHierarchy().getTupleDimensionalityIndex());
            this.categoryIndices.add(fMember.getHierarchy().getTupleDimensionalityIndex());
            this.categoryIndices.add(fMember.getUniqueHierarchyMemberIndex());
        }
        this.__debug_NAME = new String[0];
        this.dimensionality = new S_TupleDimensionalityDef(tuple.getTupleDimensionality());
    }

    @Override
    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public boolean isFilteredOut() {
        return this.filteredOut;
    }

    @Override
    public S_TupleDimensionality getClusterTupleDimensionality() {
        return this.dimensionality.getTupleDimensionality();
    }

    @Override
    public int getMemberCount() {
        return this.categoryIndices.size();
    }

    @Override
    public void forEach(S_FactMemberDefIndices indices) {
        int categoryCount = this.categoryIndices.size();
        int ii = 0;
        while (ii < categoryCount) {
            OlapHierarchyScope scope = this.categoryScopes.get(ii);
            long cacheId = this.categoryCacheIds.get(ii);
            int iHierarchyIndex = this.categoryIndices.get(ii++);
            int hierarchyIndex = this.categoryIndices.get(ii++);
            int memberIndex = this.categoryIndices.get(ii++);
            S_FactMemberInfo info = new S_FactMemberInfo(scope, cacheId);
            indices.apply(S_MemberDefType.CATEGORY, iHierarchyIndex, hierarchyIndex, memberIndex, info);
        }
        int standardCount = this.standardIndices.size();
        int ii2 = 0;
        while (ii2 < standardCount) {
            int iHierarchyIndex = this.standardIndices.get(ii2++);
            int hierarchyIndex = this.standardIndices.get(ii2++);
            int memberIndex = this.standardIndices.get(ii2++);
            indices.apply(S_MemberDefType.STANDARD, iHierarchyIndex, hierarchyIndex, memberIndex, null);
        }
    }

    @Override
    public boolean isMeasure() {
        return this.isMeasure;
    }
}

