/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.schema;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cluster.master.schema.M_SchemaDefFactory;
import crazydev.iccube.cluster.shared.common.S_ContextRef;
import crazydev.iccube.cluster.shared.facts.bitmap.S_FactBitmapContainerFactory;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public class S_BuildSchemaContextRef
extends S_ContextRef {
    private static final AtomicLong NEXT_UID = new AtomicLong(0L);
    private final String m_clientUUID;
    private final S_BuildSchemaContextKind m_kind;
    private final OlapSchema m_schema;
    @Nullable
    private final Object m_backup;
    @Nullable
    private final Object m_restore;
    private final OlapRuntimeContext runtimeContext;
    private final OlapBuilderContext builderContext;

    public S_BuildSchemaContextRef(String clientUUID, S_BuildSchemaContextKind kind, OlapSchema schema, @Nullable Object backup, @Nullable Object restore, OlapRuntimeContext runtimeContext, OlapBuilderContext builderContext) {
        super(schema.getName(), NEXT_UID.getAndIncrement());
        this.m_clientUUID = clientUUID;
        this.m_kind = kind;
        this.m_schema = schema;
        this.m_backup = backup;
        this.m_restore = restore;
        this.runtimeContext = runtimeContext;
        this.builderContext = builderContext;
    }

    public S_BuildSchemaContextInitData createObjectInitData(@Nullable IOlapFactListFactory factsColumnListFactory, @Nullable S_FactBitmapContainerFactory factsBitmapContainerFactory) {
        return new S_BuildSchemaContextInitData(this, this.m_clientUUID, switch (this.m_kind) {
            case S_BuildSchemaContextKind.FULL_LOAD -> {
                if (factsColumnListFactory == null) {
                    throw new RuntimeException("internal error: schema [" + this.m_schema.getName() + "] missing facts column factory");
                }
                if (factsBitmapContainerFactory == null) {
                    throw new RuntimeException("internal error: schema [" + this.m_schema.getName() + "] missing facts index factory");
                }
                yield M_SchemaDefFactory.createSchemaDef(this.m_schema.getClusterRef(), this.m_schema.getName(), this.m_schema.getDefinitionFactory(), this.m_schema.getDimensions(), factsColumnListFactory, factsBitmapContainerFactory);
            }
            case S_BuildSchemaContextKind.INCREMENTAL_LOAD -> {
                if (!this.m_schema.hasClusterSchemaDef()) {
                    throw new RuntimeException("internal error: incr. load [" + this.m_schema.getName() + "] missing cluster schema definition");
                }
                yield this.m_schema.getClusterSchemaDef();
            }
            case S_BuildSchemaContextKind.PARTITION_LOAD -> {
                if (!this.m_schema.hasClusterSchemaDef()) {
                    throw new RuntimeException("internal error: partition load [" + this.m_schema.getName() + "] missing cluster schema definition");
                }
                yield this.m_schema.getClusterSchemaDef();
            }
            default -> throw new RuntimeException("internal error: unexpected load kind [" + String.valueOf((Object)this.m_kind) + "]");
        }, this.m_schema.isMonitoring(), this.m_kind, this.m_backup, this.m_restore, this.runtimeContext, this.builderContext);
    }
}

