/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.perms;

import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationRuntimeException;
import crazydev.iccube.authorizationx.flat.permissions.schema.OlapRoleFlatSchemaFactFilterLine;
import crazydev.iccube.authorizationx.permissions.schemas.OlapRoleSchemasPermissionsTimings;
import crazydev.iccube.cluster.master.schema.M_SchemaSubCubeFactory;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_BitSetTupleDimensionality;
import crazydev.iccube.cluster.shared.schema.S_FactSubCube;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class S_FactAllMeasureGroupsPermsDef
extends S_FactPermsDef {
    private final OlapRoleSchemasPermissionsTimings timings;
    private final List<OlapRoleFlatSchemaFactFilterLine> filterLines;

    public S_FactAllMeasureGroupsPermsDef(OlapRoleSchemasPermissionsTimings timings, List<OlapRoleFlatSchemaFactFilterLine> filterLines) {
        this.timings = timings;
        this.filterLines = filterLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public OlapBitmapTor createBitmapTor(String role, S_MeasureGroupDef measureGroup, N_FactBitmapContainer bitmapContainer) {
        long startMS = System.currentTimeMillis();
        try {
            OlapBitmapTor olapBitmapTor = this.doCreateBitmapTor(role, measureGroup, bitmapContainer);
            return olapBitmapTor;
        }
        finally {
            long elapsedMS = System.currentTimeMillis() - startMS;
            String schema = bitmapContainer.getSchemaName();
            if (OlapLoggers.AUTHORIZATION.isDebugEnabled()) {
                OlapLoggers.AUTHORIZATION.debug((Object)("[auth] schema [" + schema + "] perms. elapsed (facts) : " + CdTimeUtils.formatMillis((long)elapsedMS) + " :: " + measureGroup.getMeasureGroupName() + " :: " + bitmapContainer.getNameForStats()));
            }
            this.timings.addElapsedMS(schema, elapsedMS);
        }
    }

    private OlapBitmapTor doCreateBitmapTor(String role, S_MeasureGroupDef measureGroup, N_FactBitmapContainer bitmapContainer) {
        Sign onlySign;
        String cubeName = measureGroup.getCubeName();
        String measureGroupName = measureGroup.getName();
        List<OlapRoleFlatSchemaFactFilterLine> mgLines = OlapRoleFlatSchemaFactFilterLine.filter(this.filterLines, cubeName, measureGroupName);
        List<OlapRoleFlatSchemaFactFilterLine> mgLinesF = !M_SchemaSubCubeFactory.NON_MAPPED_PERMISSIONS_ACTIVATED || mgLines.isEmpty() ? mgLines : ((onlySign = S_FactAllMeasureGroupsPermsDef.extractOnlySign(mgLines)) != null ? S_FactAllMeasureGroupsPermsDef.filterLinesWithSingleSign(bitmapContainer, mgLines) : S_FactAllMeasureGroupsPermsDef.filterLinesWithMultiSign(bitmapContainer, mgLines));
        S_FactSubCube subCube = M_SchemaSubCubeFactory.createForPerms(mgLinesF);
        if (subCube != null) {
            return subCube.createBitmapTor(null, bitmapContainer, S_BitSetTupleDimensionality.ZERO);
        }
        return null;
    }

    @Nullable
    private static Sign extractOnlySign(List<OlapRoleFlatSchemaFactFilterLine> lines) {
        Sign onlySign = null;
        for (OlapRoleFlatSchemaFactFilterLine mgLine : lines) {
            if (onlySign == null) {
                onlySign = mgLine.plus ? Sign.PLUS : Sign.MINUS;
                continue;
            }
            if (mgLine.plus) {
                if (onlySign != Sign.MINUS) continue;
                onlySign = null;
                break;
            }
            if (onlySign != Sign.PLUS) continue;
            onlySign = null;
            break;
        }
        return onlySign;
    }

    private static List<OlapRoleFlatSchemaFactFilterLine> filterLinesWithSingleSign(N_FactBitmapContainer bitmapContainer, List<OlapRoleFlatSchemaFactFilterLine> lines) {
        List<OlapRoleFlatSchemaFactFilterLine> filtered = lines.stream().filter(l -> l.isIndexingOrEmpty(bitmapContainer)).toList();
        return filtered;
    }

    private static List<OlapRoleFlatSchemaFactFilterLine> filterLinesWithMultiSign(N_FactBitmapContainer bitmapContainer, List<OlapRoleFlatSchemaFactFilterLine> lines) {
        OlapRoleFlatSchemaFactFilterLine line;
        int ii;
        int firstKeptLineIndex = -1;
        OlapRoleFlatSchemaFactFilterLine firstKeptLine = null;
        for (int ii2 = 0; ii2 < lines.size(); ++ii2) {
            OlapRoleFlatSchemaFactFilterLine line2 = lines.get(ii2);
            if (!line2.isIndexingOrEmpty(bitmapContainer)) continue;
            firstKeptLineIndex = ii2;
            firstKeptLine = line2;
            break;
        }
        if (firstKeptLineIndex == -1) {
            return Collections.emptyList();
        }
        if (firstKeptLineIndex == 0) {
            return S_FactAllMeasureGroupsPermsDef.filterLinesWithSingleSign(bitmapContainer, lines);
        }
        boolean onError = false;
        Sign firstKeptLineSign = firstKeptLine.plus ? Sign.PLUS : Sign.MINUS;
        for (ii = 0; ii < firstKeptLineIndex; ++ii) {
            Sign sign;
            line = lines.get(ii);
            Sign sign2 = sign = line.plus ? Sign.PLUS : Sign.MINUS;
            if (firstKeptLineSign == sign) continue;
            onError = true;
            break;
        }
        if (onError) {
            for (ii = 0; ii <= firstKeptLineIndex; ++ii) {
                line = lines.get(ii);
                OlapLoggers.AUTHORIZATION.error((Object)("permissions : multi-sign error [" + ii + "] : " + line.asMdx()));
            }
            throw new OlapRoleAuthorizationRuntimeException("permissions : multi-sign and non-indexing dimensions not supported (contact your support)");
        }
        return S_FactAllMeasureGroupsPermsDef.filterLinesWithSingleSign(bitmapContainer, lines);
    }

    static enum Sign {
        PLUS,
        MINUS;

    }
}

