/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup.file;

import crazydev.common.utils.CdSizeUtils;
import crazydev.iccube.cluster.shared.backup.file.S_BackupFileOutputStream;
import crazydev.iccube.cluster.shared.backup.file.S_BackupFileOutputStreamHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class S_BackupMultiFileOutputStream
extends S_BackupFileOutputStream {
    private final File file_;
    private final List<File> allFiles = new ArrayList<File>();
    private final List<FileOutputStream> allStreams = new ArrayList<FileOutputStream>();
    private final long localMaxSizeB;
    private long localSizeB;

    public S_BackupMultiFileOutputStream(File file, long maxSizeB) throws IOException {
        super(file);
        this.file_ = file;
        this.allFiles.add(this.file);
        this.allStreams.add(this.stream);
        this.localMaxSizeB = maxSizeB;
        this.localSizeB = 0L;
    }

    private void addFile() throws IOException {
        File newFile = S_BackupFileOutputStreamHelper.newFile(this.file_, this.allFiles.size());
        OlapLoggers.BACKUP.debug((Object)("[backup] adding a new file [" + this.file.getName() + "] [" + newFile.getName() + "] [" + CdSizeUtils.format((double)this.localMaxSizeB) + "]"));
        this.stream.flush();
        this.file = newFile;
        this.stream = new FileOutputStream(this.file);
        this.allFiles.add(this.file);
        this.allStreams.add(this.stream);
        this.localSizeB = 0L;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.localSizeB + 1L <= this.localMaxSizeB) {
            super.write(b);
            ++this.localSizeB;
            return;
        }
        this.addFile();
        this.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.localSizeB + (long)len <= this.localMaxSizeB) {
            super.write(b, off, len);
            this.localSizeB += (long)len;
            return;
        }
        int remaining = (int)(this.localMaxSizeB - this.localSizeB);
        this.write(b, off, remaining);
        this.addFile();
        this.write(b, off + remaining, len - remaining);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        for (FileOutputStream stream : this.allStreams) {
            stream.flush();
        }
    }

    @Override
    public void sync() throws IOException {
        for (FileOutputStream stream : this.allStreams) {
            stream.flush();
            stream.getFD().sync();
        }
    }

    @Override
    public void close() throws IOException {
        for (FileOutputStream stream : this.allStreams) {
            stream.close();
        }
    }
}

