/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.shared.backup.file;

import crazydev.iccube.cluster.shared.backup.file.S_BackupFileInputStream;
import crazydev.iccube.cluster.shared.backup.file.S_BackupFileOutputStreamHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class S_BackupMultiFileInputStream
extends S_BackupFileInputStream {
    private final File file_;
    private int counter = 1;

    public S_BackupMultiFileInputStream(File file) throws IOException {
        super(file);
        this.file_ = file;
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        if (val != -1) {
            return val;
        }
        if (!this.switchFile()) {
            return -1;
        }
        return this.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count == len) {
            return len;
        }
        if (count == -1) {
            if (!this.switchFile()) {
                return -1;
            }
            return this.read(b, off, len);
        }
        if (!this.switchFile()) {
            return count;
        }
        int count_ = this.read(b, off + count, len - count);
        return count + count_;
    }

    private boolean switchFile() throws IOException {
        File newFile = S_BackupFileOutputStreamHelper.newFile(this.file_, this.counter);
        if (newFile.exists()) {
            this.stream.close();
            this.file = newFile;
            this.stream = new FileInputStream(this.file);
            ++this.counter;
            return true;
        }
        return false;
    }
}

