/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.common.collection.CdArrayList;
import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdPair;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupManager;
import crazydev.iccube.cluster.node.context.N_ApplicationContext;
import crazydev.iccube.cluster.node.context.N_FastCrossjoinContext;
import crazydev.iccube.cluster.node.context.N_MdxRequestContext;
import crazydev.iccube.cluster.node.context.N_OlapContextLoggers;
import crazydev.iccube.cluster.node.facts.N_FactPage;
import crazydev.iccube.cluster.node.facts.N_MeasureGroup;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_Category;
import crazydev.iccube.cluster.node.schema.N_FastCj_Cache;
import crazydev.iccube.cluster.node.schema.N_SchemaCategoryManager;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.cluster.shared.schema.S_CubeDef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_FactTupleDef;
import crazydev.iccube.cluster.shared.schema.S_FactTuplesDef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehavior;
import crazydev.iccube.cluster.shared.schema.S_RequestSubCubeDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.cluster.shared.schema.S_TupleDimensionalityDef;
import crazydev.iccube.cluster.shared.schema.S_VisualTotalsDef;
import crazydev.iccube.collection.IOlapIteratorFilter;
import crazydev.iccube.collection.olapiterator.fastcj.CjBitmapHelper;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.entity.tuple.dimensionality.OlapTupleDimensionality;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.facts.OlapFactMeasureGroupBaseManager;
import crazydev.iccube.olap.facts.column.columns.OlapScalarEntityFactColumn;
import crazydev.iccube.olap.facts.column.list.IOlapFactListFactory;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaDumpIndexHierarchies;
import crazydev.iccube.olap.schema.OlapSchemaInformationForTests;
import crazydev.iccube.olap.schema.stats.OlapCategoryStats;
import crazydev.iccube.olap.schema.stats.OlapFactsLevelsBitmapsStats;
import crazydev.iccube.olap.schema.stats.OlapFactsPartitionStats;
import crazydev.iccube.olap.schema.stats.OlapStatsContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class N_Schema {
    private static final CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> EMPTY_RES = new CdPair(Collections.emptyList(), (Object)0);
    private static final int[] SORTED_SIZE_ONE = new int[]{0};
    private final N_ApplicationContext appContext;
    private final S_SchemaDef schemaDef;
    private final Map<S_MeasureGroupRef, N_MeasureGroup> measureGroups = new HashMap<S_MeasureGroupRef, N_MeasureGroup>();
    private final Map<S_MeasureGroupRef, N_MeasureGroup> measureGroupsForLoadPartitions = new ConcurrentHashMap<S_MeasureGroupRef, N_MeasureGroup>();
    private final N_SchemaCategoryManager categoryManager;

    public N_Schema(N_ApplicationContext appContext, S_SchemaDef schemaDef) {
        this.appContext = appContext;
        this.schemaDef = schemaDef;
        for (S_CubeDef cubeDef : schemaDef.getAllCubes()) {
            for (S_MeasureGroupDef measureGroupDef : cubeDef.getAllMeasureGroups()) {
                S_MeasureGroupRef measureGroupRef = measureGroupDef.getRef();
                N_MeasureGroup measureGroup = N_MeasureGroup.create(S_BuildSchemaContextKind.FULL_LOAD, schemaDef, cubeDef, measureGroupDef);
                this.measureGroups.put(measureGroupRef, measureGroup);
            }
        }
        this.categoryManager = new N_SchemaCategoryManager();
        schemaDef.getRef().getSchema().registerNSchema(this);
    }

    public void onSchemaStartedPhaseI(String command) {
        this.onSchemaStartedPhaseN("I", command);
    }

    public void onSchemaStartedPhaseII(String command) {
        this.onSchemaStartedPhaseN("II", command);
    }

    private void onSchemaStartedPhaseN(String phase, String command) {
        int size = this.measureGroupsForLoadPartitions.size();
        StringBuilder sb = new StringBuilder();
        if (size > 0) {
            this.measureGroupsForLoadPartitions.forEach((groupRef, group) -> sb.append(groupRef.getMeasureGroupName()).append(","));
        }
        OlapLoggers.BUILDER.info((Object)("[facts] " + command + " (PHASE-" + phase + ") schema [" + this.getName() + "] measure-groups-for-load-partitions [" + size + "] [" + String.valueOf(sb) + "]"));
    }

    public void onSchemaPartitionsLoaded() {
        for (N_MeasureGroup measureGroup : this.measureGroupsForLoadPartitions.values()) {
            measureGroup.onSchemaPartitionsLoaded();
        }
        OlapLoggers.BUILDER.info((Object)("[facts] schema [" + this.getName() + "] clear its measure-groups-for-load-partitions (loaded)"));
        this.measureGroupsForLoadPartitions.clear();
    }

    public void onSchemaPartitionsLoadedOnError() {
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        for (N_MeasureGroup measureGroup : this.measureGroupsForLoadPartitions.values()) {
            measureGroup.onSchemaPartitionsLoadedOnError(fileCleaner);
        }
        OlapLoggers.BUILDER.info((Object)("[facts] schema [" + this.getName() + "] clear its measure-groups-for-load-partitions (loaded-on-error)"));
        this.measureGroupsForLoadPartitions.clear();
    }

    public void onSchemaUnloaded() {
        this.cleanupResources();
    }

    public S_SchemaRef getSchemaRef() {
        return this.schemaDef.getRef();
    }

    public S_SchemaDef getSchemaDef() {
        return this.schemaDef;
    }

    public String getName() {
        return this.schemaDef.getName();
    }

    public N_MeasureGroup getMeasureGroupForFullLoadRestore(String cubeName, String measureGroupName) {
        for (N_MeasureGroup measureGroup : this.measureGroups.values()) {
            if (!measureGroup.getCubeName().equals(cubeName) || !measureGroup.getName().equals(measureGroupName)) continue;
            return measureGroup;
        }
        throw new RuntimeException("internal error: missing measure group [" + cubeName + "] [" + measureGroupName + "] in schema [" + this.getName() + "] for restoring partitions (full load)");
    }

    public N_MeasureGroup getMeasureGroupForLoadPartitionsRestore(String cubeName, String measureGroupName) {
        for (N_MeasureGroup measureGroup : this.measureGroupsForLoadPartitions.values()) {
            if (!measureGroup.getCubeName().equals(cubeName) || !measureGroup.getName().equals(measureGroupName)) continue;
            return measureGroup;
        }
        throw new RuntimeException("internal error: missing measure group [" + cubeName + "] [" + measureGroupName + "] in schema [" + this.getName() + "] for restoring partitions (load partitions)");
    }

    public void cleanupResources() {
        OlapLoggers.GENERAL.info((Object)("[builder] cleanup resources for schema [" + this.getName() + "]"));
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        for (N_MeasureGroup measureGroup : this.measureGroups.values()) {
            OlapLoggers.GENERAL.debug((Object)("[builder] cleanup resources for schema [" + this.getName() + "] [" + measureGroup.getName() + "]"));
            measureGroup.cleanupResources(fileCleaner);
        }
        for (N_MeasureGroup measureGroup : this.measureGroupsForLoadPartitions.values()) {
            OlapLoggers.GENERAL.debug((Object)("[builder] cleanup resources for schema [" + this.getName() + "] [" + measureGroup.getName() + "]"));
            measureGroup.cleanupResources(fileCleaner);
        }
        IOlapFactListFactory factsColumnListFactory = this.schemaDef.getFactsColumnListFactory();
        File mmapDirectory = factsColumnListFactory.getMmapDirectory();
        if (mmapDirectory != null) {
            OlapLoggers.GENERAL.debug((Object)("[mmap] schema [" + this.getName() + "] deleting [" + mmapDirectory.getAbsolutePath() + "]"));
            boolean deleted = CdVFileSystemUtils.deleteQuietly((File)mmapDirectory);
            if (!deleted) {
                fileCleaner.register(mmapDirectory);
            }
            OlapLoggers.GENERAL.debug((Object)("[mmap] schema [" + this.getName() + "] deleted [" + deleted + "] [" + mmapDirectory.getAbsolutePath() + "]"));
        }
    }

    public void clearOnIncrLoadFullReload(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for clear-on-incr-load-full-reload");
        }
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        measureGroup.clearOnIncrLoadFullReload(fileCleaner);
    }

    public void unloadPartitions(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, List<S_FactPageRef> partitionRefs) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for unloading partitions");
        }
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        measureGroup.unloadPartitions(fileCleaner, partitionRefs);
    }

    public void unloadMeasureGroup(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for unloading measure group");
        }
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        measureGroup.unloadMeasureGroup(fileCleaner);
    }

    public void adoptPartitions(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, @Nullable S_FactPageRef partition, S_FactPageRef loadedPartition) {
        N_MeasureGroup existingMeasureGroup = this.measureGroups.get(measureGroupRef);
        if (existingMeasureGroup == null) {
            throw new RuntimeException("internal error: missing (existing) measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for adopting partitions");
        }
        N_MeasureGroup loadedMeasureGroup = this.measureGroupsForLoadPartitions.get(measureGroupRef);
        if (loadedMeasureGroup == null) {
            throw new RuntimeException("internal error: missing (loaded) measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for adopting partitions");
        }
        OlapFileCleaner fileCleaner = this.appContext.getFileCleaner();
        existingMeasureGroup.adoptPartitions(fileCleaner, loadedMeasureGroup, partition, loadedPartition);
    }

    public void getInformationForPerformanceTests(OlapSchemaInformationForTests info, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for partition index [" + String.valueOf(partitionRef) + "]");
        }
        measureGroup.getInformationForPerformanceTests(info, partitionRef);
    }

    public void dumpIndex(FileOutputStream out, OlapSchemaDumpIndexHierarchies hierarchies, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef) throws IOException {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for partition index [" + String.valueOf(partitionRef) + "]");
        }
        measureGroup.dumpIndex(out, hierarchies, partitionRef);
    }

    public void createPartitionStats(OlapStatsContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef, OlapFactsLevelsBitmapsStats statsPerLevel, List<OlapFactsPartitionStats> partitionsStats, Set<OlapDimension> dimensions__) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for partition stats [" + String.valueOf(partitionRef) + "]");
        }
        measureGroup.createPartitionStats(context, statsPerLevel, partitionsStats, partitionRef, dimensions__);
    }

    public void createIncrLoadPartitionStats(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef partitionRef, List<OlapFactsPartitionStats> partitionsStats) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] in schema [" + this.getName() + "] for incr. load partition stats [" + String.valueOf(partitionRef) + "]");
        }
        measureGroup.createIncrLoadPartitionStats(partitionsStats, partitionRef);
    }

    public N_FactPage createFactPage(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        if (!context.isLoadPartitions()) {
            return this.doCreateFactPage(context, cubeRef, measureGroupRef, factPageRef, backupID, nameForStats);
        }
        return this.doCreateFactPageForLoadPartitions(context, cubeRef, measureGroupRef, factPageRef, empty, backupID, nameForStats);
    }

    private N_FactPage doCreateFactPage(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef, int backupID, String nameForStats) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: [" + this.schemaDef.getName() + "] missing measure group [" + String.valueOf(measureGroupRef) + "]");
        }
        N_FactPage factPage = measureGroup.createFactPage(context, cubeRef, measureGroupRef, factPageRef, false, backupID, nameForStats);
        return factPage;
    }

    public N_FactPage getFactPage(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        if (!context.isLoadPartitions()) {
            return this.doGetFactPage(cubeRef, measureGroupRef, factPageRef);
        }
        return this.doGetFactPageForLoadPartitions(cubeRef, measureGroupRef, factPageRef);
    }

    private N_FactPage doGetFactPage(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_FactPage factPage = N_Schema.getFactPage(this.measureGroups, this.schemaDef, cubeRef, measureGroupRef, factPageRef);
        return factPage;
    }

    private static N_FactPage getFactPage(Map<S_MeasureGroupRef, N_MeasureGroup> measureGroups, S_SchemaDef schemaDef, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        Object referenced = factPageRef.getReferenced();
        if (referenced != null) {
            return (N_FactPage)referenced;
        }
        N_MeasureGroup measureGroup = measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: [" + schemaDef.getName() + "] missing measure group [" + String.valueOf(measureGroupRef) + "]");
        }
        N_FactPage factPage = measureGroup.getFactPage(cubeRef, measureGroupRef, factPageRef);
        return factPage;
    }

    private N_FactPage doCreateFactPageForLoadPartitions(N_BuildFactContext context, S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        N_MeasureGroup measureGroup = this.measureGroupsForLoadPartitions.get(measureGroupRef);
        if (measureGroup == null) {
            measureGroup = this.createMeasureGroupForLoadPartitions(cubeRef, measureGroupRef);
        }
        N_FactPage factPage = measureGroup.createFactPage(context, cubeRef, measureGroupRef, factPageRef, empty, backupID, nameForStats);
        return factPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private N_MeasureGroup createMeasureGroupForLoadPartitions(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef) {
        Map<S_MeasureGroupRef, N_MeasureGroup> map = this.measureGroupsForLoadPartitions;
        synchronized (map) {
            N_MeasureGroup measureGroup = this.measureGroupsForLoadPartitions.get(measureGroupRef);
            if (measureGroup == null) {
                S_CubeDef cubeDef = this.schemaDef.resolveCube(cubeRef);
                S_MeasureGroupDef measureGroupDef = cubeDef.getMeasureGroup(measureGroupRef);
                measureGroup = N_MeasureGroup.create(S_BuildSchemaContextKind.PARTITION_LOAD, this.schemaDef, cubeDef, measureGroupDef);
                OlapLoggers.BUILDER.info((Object)("[facts] schema [" + this.getName() + "] create measure-groups-for-load-partitions for [" + measureGroupRef.getMeasureGroupName() + "]"));
                this.measureGroupsForLoadPartitions.put(measureGroupRef, measureGroup);
            }
            return measureGroup;
        }
    }

    private N_FactPage doGetFactPageForLoadPartitions(S_CubeRef cubeRef, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_FactPage factPage = N_Schema.getFactPage(this.measureGroupsForLoadPartitions, this.schemaDef, cubeRef, measureGroupRef, factPageRef);
        return factPage;
    }

    public void onDimensionChanged(N_BuildSchemaContext context, S_IncrLoadDimensionUpdateDef incrLoadUpdate, S_HollowUpdate hollowUpdate) {
        Logger logger = context.loggers().builder();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[builder] on-dimension-changed [schema:" + this.getName() + "]"));
        }
        this.schemaDef.resizeDimension(context, incrLoadUpdate);
        for (N_MeasureGroup measureGroup : this.measureGroups.values()) {
            measureGroup.onDimensionChanged(context, incrLoadUpdate, hollowUpdate);
        }
    }

    public void onTableRowsProcessingCompleted(N_BuildSchemaContext context, S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        N_MeasureGroup measureGroup;
        OlapLoggers.BUILDER.info((Object)("[facts] table rows processing completed for schema [" + this.getName() + "] " + String.valueOf(factPageRef)));
        if (!context.isLoadPartitions()) {
            measureGroup = this.measureGroups.get(measureGroupRef);
            if (measureGroup == null) {
                throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] from schema [" + this.getName() + "]");
            }
        } else {
            measureGroup = this.measureGroupsForLoadPartitions.get(measureGroupRef);
        }
        if (measureGroup == null) {
            return;
        }
        measureGroup.onTableRowsProcessingCompleted(context, factPageRef);
    }

    public void onProcessFactsCompleted(N_BuildSchemaContext context, S_MeasureGroupRef measureGroupRef, S_HierarchyDimensionality indexingHierarchies) {
        N_MeasureGroup measureGroup;
        OlapLoggers.BUILDER.info((Object)("[facts] process completed for schema [" + this.getName() + "] [" + measureGroupRef.getMeasureGroupName() + "]"));
        if (!context.isLoadPartitions()) {
            measureGroup = this.measureGroups.get(measureGroupRef);
            if (measureGroup == null) {
                throw new RuntimeException("internal error: (facts) missing measure group [" + String.valueOf(measureGroupRef) + "] from schema [" + this.getName() + "]");
            }
        } else {
            measureGroup = this.measureGroupsForLoadPartitions.get(measureGroupRef);
        }
        if (measureGroup == null) {
            return;
        }
        measureGroup.onProcessFactsCompleted(context, indexingHierarchies);
        Object backup = context.getBackup();
        if (backup != null) {
            N_BackupManager backupManager = this.appContext.getBackupManager();
            backupManager.saveFacts(backup, measureGroup);
        }
    }

    public void onIncrLoadProcessFactsCompleted(N_BuildSchemaContext context, S_MeasureGroupRef measureGroupRef) {
        N_MeasureGroup measureGroup;
        N_OlapContextLoggers loggers = context.loggers();
        Logger builder = loggers.builder();
        if (builder.isInfoEnabled()) {
            builder.info((Object)("[facts] incr. load process completed for schema [" + this.getName() + "] [" + measureGroupRef.getMeasureGroupName() + "]"));
        }
        if ((measureGroup = this.measureGroups.get(measureGroupRef)) == null) {
            throw new RuntimeException("internal error: (facts) missing measure group [" + String.valueOf(measureGroupRef) + "] from schema [" + this.getName() + "]");
        }
        measureGroup.onIncrLoadProcessFactsCompleted(context);
    }

    public N_MeasureGroup getMeasureGroup(S_MeasureGroupRef measureGroupRef) {
        N_MeasureGroup measureGroup = this.measureGroups.get(measureGroupRef);
        if (measureGroup == null) {
            throw new RuntimeException("internal error: missing measure group [" + String.valueOf(measureGroupRef) + "] from schema [" + this.getName() + "]");
        }
        return measureGroup;
    }

    public N_MeasureGroup getMeasureGroup(OlapFactMeasureGroupBaseManager measureGroup) {
        S_MeasureGroupRef measureGroupRef = measureGroup.getClusterRef();
        return this.getMeasureGroup(measureGroupRef);
    }

    public OlapScalarEntityFactColumn[] factsColumnForTests__() {
        Iterator<N_MeasureGroup> iterator = this.measureGroups.values().iterator();
        if (iterator.hasNext()) {
            N_MeasureGroup measureGroup = iterator.next();
            return measureGroup.factsColumnForTests__();
        }
        throw new RuntimeException("internal error: cannot retrieve facts column");
    }

    public IOlapIteratorFilter<OlapMember> getFastNonEmptyFilter(N_MdxRequestContext context, GFContext dtContext, S_MeasureGroupRef measureGroupRef, S_FactTupleDef tupleDef, OlapMeasureMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_MeasureGroup measureGroup = this.getMeasureGroup(measureGroupRef);
        return measureGroup.getFastNonEmptyFilter(context, dtContext, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
    }

    public OlapScalarEntity evalTuple(N_MdxRequestContext context, GFContext dtContext, S_MeasureGroupRef measureGroupRef, S_FactTupleDef tupleDef, OlapMeasureMember measure, @Nullable S_TupleDimensionalityDef overwrittenHierarchies, @Nullable S_VisualTotalsDef visualTotals, @Nullable List<S_RequestSubCubeDef> subCubes) {
        N_MeasureGroup measureGroup = this.getMeasureGroup(measureGroupRef);
        OlapScalarEntity res = measureGroup.evalTuple(context, dtContext, tupleDef, measure, overwrittenHierarchies, visualTotals, subCubes);
        return res;
    }

    public List<CjBitmapHelper.CjBitmap> fastcrossjoin_init(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, OlapTupleDimensionality cjTupleDimensionality, List<S_FactTuplesDef> tuplesList, int limitSize) {
        CdArrayList newReducingBitmaps = new CdArrayList();
        N_MeasureGroup[] sortedMeasuresGroups = context.getSortedMeasureGroupsByRowSize(nonEmptyBehavior, this::getMeasureGroup);
        int hasSizeOne = 0;
        int[] positions = CdArrays.sortedBubblePositions((int)tuplesList.size(), (i, j) -> Integer.compare(((S_FactTuplesDef)tuplesList.get(i)).size(), ((S_FactTuplesDef)tuplesList.get(j)).size()));
        for (int arPos = 0; arPos < positions.length; ++arPos) {
            int actualPos = positions[arPos];
            S_FactTuplesDef tuples = tuplesList.get(actualPos);
            CjBitmapHelper.CjBitmap newReducingBitmap = this.fastcrossjoin_init_calc(context, cjTupleDimensionality, sortedMeasuresGroups, tuples, null);
            int n = hasSizeOne = newReducingBitmap.cardinality() == 1L ? arPos : hasSizeOne;
            if (newReducingBitmap.cardinality() == 0L) {
                return Collections.emptyList();
            }
            if (newReducingBitmap.cardinality() < 5L && tuples.size() != 1 && !tuples.get(0).isAll()) {
                Arrays.stream(sortedMeasuresGroups).forEach(measureGroup -> measureGroup.fast_crossjoin_addToGlobalFilter(context, tuples, newReducingBitmap));
            }
            newReducingBitmaps.set(actualPos, (Object)newReducingBitmap);
        }
        if (hasSizeOne > 0) {
            this.fastcrossjoin_applySizeOneBackwards(context, cjTupleDimensionality, sortedMeasuresGroups, tuplesList, positions, (List<CjBitmapHelper.CjBitmap>)newReducingBitmaps, hasSizeOne);
        }
        boolean setPos = false;
        CdArrayList filteredTuples = new CdArrayList();
        for (int i2 = 0; i2 < tuplesList.size(); ++i2) {
            S_FactTuplesDef tuples = tuplesList.get(i2);
            CjBitmapHelper.CjBitmap filter = (CjBitmapHelper.CjBitmap)newReducingBitmaps.get(i2);
            if (filter != null && filter.cardinality() <= 1L) continue;
            filteredTuples.add((Object)tuples.asFiltered(filter));
        }
        context.initSet((CdArrayList<S_FactTuplesDef>)filteredTuples);
        if (sortedMeasuresGroups.length == 1) {
            sortedMeasuresGroups[0].fastcrossjoin_initTable(context);
        }
        return newReducingBitmaps;
    }

    private boolean fastcrossjoin_applySizeOneBackwards(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality, N_MeasureGroup[] sortedMeasuresGroups, List<S_FactTuplesDef> tuplesList, int[] positions, List<CjBitmapHelper.CjBitmap> newReducingBitmaps, int sizeOneBitmapPos) {
        int lSizeOneBitmapPos = 0;
        for (int arPos = 0; arPos < sizeOneBitmapPos; ++arPos) {
            CjBitmapHelper.CjBitmap bitmap;
            CjBitmapHelper.CjBitmap oldReducingBitmap;
            int actualPos = positions[arPos];
            S_FactTuplesDef tuples = tuplesList.get(actualPos);
            CjBitmapHelper.CjBitmap newReducingBitmap = this.fastcrossjoin_init_calc(context, cjTupleDimensionality, sortedMeasuresGroups, tuples, oldReducingBitmap = newReducingBitmaps.get(actualPos));
            if (newReducingBitmap.isEmpty()) {
                return false;
            }
            if (newReducingBitmap.cardinality() == oldReducingBitmap.cardinality()) continue;
            newReducingBitmaps.set(actualPos, newReducingBitmap);
            if (newReducingBitmap.cardinality() == 1L) {
                bitmap = newReducingBitmap;
                Arrays.stream(sortedMeasuresGroups).forEach(measureGroup -> measureGroup.fast_crossjoin_addToGlobalFilter(context, tuples, bitmap));
                lSizeOneBitmapPos = actualPos;
                continue;
            }
            if (newReducingBitmap.cardinality() >= 5L || oldReducingBitmap.cardinality() < 5L) continue;
            bitmap = newReducingBitmap;
            Arrays.stream(sortedMeasuresGroups).forEach(measureGroup -> measureGroup.fast_crossjoin_addToGlobalFilter(context, tuples, bitmap));
        }
        if (lSizeOneBitmapPos > 0) {
            return this.fastcrossjoin_applySizeOneBackwards(context, cjTupleDimensionality, sortedMeasuresGroups, tuplesList, positions, newReducingBitmaps, tuplesList.size());
        }
        return true;
    }

    private CjBitmapHelper.CjBitmap fastcrossjoin_init_calc(N_FastCrossjoinContext context, OlapTupleDimensionality cjTupleDimensionality, N_MeasureGroup[] sortedMeasuresGroups, S_FactTuplesDef tuples, @Nullable CjBitmapHelper.CjBitmap filter) {
        N_MeasureGroup measureGroup;
        for (int j = 0; j < sortedMeasuresGroups.length; ++j) {
            N_MeasureGroup measureGroup2 = sortedMeasuresGroups[j];
            measureGroup2.fastcrossjoin_preInit(context, cjTupleDimensionality);
        }
        CjBitmapHelper.CjBitmap newReducingBitmap = CjBitmapHelper.createBitmap();
        for (int j = 0; j < sortedMeasuresGroups.length && (newReducingBitmap = (measureGroup = sortedMeasuresGroups[j]).fastcrossjoin_init(context, cjTupleDimensionality, tuples, filter, newReducingBitmap)).cardinality() != (long)tuples.size(); ++j) {
        }
        return newReducingBitmap;
    }

    public void fastcrossjoin_initReduce(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, CjBitmapHelper.CjTupleListReducer isNotEmpty, int tupleListindex, int start, int end) {
        N_MeasureGroup[] sortedMeasuresGroups = context.getSortedMeasureGroupsByRowSize(nonEmptyBehavior, this::getMeasureGroup);
        CjBitmapHelper.CjBitmap reducedBitmap = CjBitmapHelper.createBitmapSingleRange(start, end);
        for (int j = 0; j < sortedMeasuresGroups.length; ++j) {
            N_MeasureGroup measureGroup = sortedMeasuresGroups[j];
            isNotEmpty = measureGroup.fastcrossjoin_reduce(context, nonEmptyBehavior, false, tupleListindex, reducedBitmap, null, isNotEmpty);
        }
    }

    public CdPair<List<CjBitmapHelper.CjTupleListReducer>, Integer> fastcrossjoin_reduce(N_FastCrossjoinContext context, S_NonEmptyBehavior nonEmptyBehavior, int firstSetIndex, List<CjBitmapHelper.CjTupleListReducer> tuplesReducer, S_FactTupleDef filterMembers) {
        N_MeasureGroup[] sortedMeasuresGroups = context.getSortedMeasureGroupsByRowSize(nonEmptyBehavior, this::getMeasureGroup);
        int[] tuplesReducerSortedIdx = this.getSortedBitmapsPositions(tuplesReducer);
        CdArrayList newReducingList = new CdArrayList(tuplesReducer.size());
        N_FastCj_Cache filterCache = new N_FastCj_Cache(filterMembers);
        boolean mightBeRedundant = false;
        for (int redIndex = 0; redIndex < tuplesReducerSortedIdx.length; ++redIndex) {
            N_MeasureGroup measureGroup;
            int actualPosition = tuplesReducerSortedIdx[redIndex];
            CjBitmapHelper.CjTupleListReducer reducedBitmap = tuplesReducer.get(actualPosition);
            CjBitmapHelper.CjTupleListReducer newReducingBitmap = CjBitmapHelper.createBitmap();
            for (int i = 0; i < sortedMeasuresGroups.length && (newReducingBitmap = (measureGroup = sortedMeasuresGroups[i]).fastcrossjoin_reduce(context, nonEmptyBehavior, true, firstSetIndex + actualPosition, reducedBitmap, filterCache, newReducingBitmap)).cardinality() != reducedBitmap.cardinality(); ++i) {
            }
            if (newReducingBitmap.isEmpty()) {
                return EMPTY_RES;
            }
            long car = newReducingBitmap.cardinality();
            mightBeRedundant |= redIndex == 0 && car == 1L;
            if (car == 1L && redIndex + 1 < tuplesReducerSortedIdx.length) {
                S_FactTuplesDef filterSet = context.getInitialSet(firstSetIndex + actualPosition);
                filterCache.addToFilter(filterSet.asFiltered(newReducingBitmap));
            }
            newReducingList.set(actualPosition, newReducingBitmap);
        }
        int redundantReducing = mightBeRedundant ? this.getNextRedundantReducing(tuplesReducerSortedIdx, (List<CjBitmapHelper.CjTupleListReducer>)newReducingList) : 0;
        return new CdPair((Object)newReducingList, (Object)redundantReducing);
    }

    private int getNextRedundantReducing(int[] tuplesReducerSortedIdx, List<CjBitmapHelper.CjTupleListReducer> newReducingList) {
        int redundantReducing = 0;
        for (int i = 0; i < newReducingList.size() && newReducingList.get(i).cardinality() == 1L; ++i) {
            int pos = CdArrays.indexOf((int[])tuplesReducerSortedIdx, (int)i) - 1;
            for (int j = 0; j < pos && tuplesReducerSortedIdx[j] <= i; ++j) {
            }
            redundantReducing = i + 1;
        }
        return redundantReducing;
    }

    private int[] getSortedBitmapsPositions(List<CjBitmapHelper.CjTupleListReducer> tuplesReducer) {
        if (tuplesReducer.size() == 1) {
            return SORTED_SIZE_ONE;
        }
        int size = tuplesReducer.size();
        return CdArrays.sortedBubblePositions((int)tuplesReducer.size(), (i, j) -> {
            long cardI = ((CjBitmapHelper.CjTupleListReducer)tuplesReducer.get(i)).cardinality();
            long cardJ = ((CjBitmapHelper.CjTupleListReducer)tuplesReducer.get(j)).cardinality();
            long compI = cardI == 1L ? (long)(i - size) : cardI;
            long compJ = cardJ == 1L ? (long)(j - size) : cardJ;
            return Long.compare(compI, compJ);
        });
    }

    public void createCategory(S_CategoryDef category, List<S_CategoryDef> children) {
        this.categoryManager.addCategory(this, category, children);
    }

    @Nullable
    public N_Category lookupCategory(int hierarchyIndex, int memberIndex, long cacheId) {
        N_Category category = this.categoryManager.getCategory(this, hierarchyIndex, memberIndex, cacheId);
        return category;
    }

    public OlapCategoryStats createCategoryStats() {
        return this.categoryManager.createCategoryStats();
    }
}

