/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.iccube.cluster.node.schema.N_Category;
import crazydev.iccube.cluster.node.schema.N_CategoryKey;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.schema.S_CategoryDef;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchyScope;
import crazydev.iccube.olap.schema.stats.OlapCategoryStats;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.Nullable;

public abstract class N_CategoryManager {
    private final OlapHierarchyScope scope;
    private final Map<N_CategoryKey, N_Category> categories = new ConcurrentHashMap<N_CategoryKey, N_Category>();

    public N_CategoryManager(OlapHierarchyScope scope) {
        this.scope = scope;
    }

    public OlapCategoryStats createCategoryStats() {
        MutableLong sizeOf = new MutableLong();
        this.categories.forEach((key, category) -> sizeOf.add(category.sizeOf()));
        return new OlapCategoryStats(this.categories.size(), sizeOf.longValue());
    }

    public void addCategory(N_Schema schema, S_CategoryDef category, List<S_CategoryDef> children) {
        this.addCategory(schema, category);
        for (S_CategoryDef child : children) {
            this.addCategory(schema, child);
        }
    }

    private void addCategory(N_Schema schema, S_CategoryDef categoryDef) {
        OlapHierarchyScope categoryScope = categoryDef.getScope();
        if (!categoryScope.equals((Object)this.scope)) {
            throw new RuntimeException("internal error: unexpected scope [" + String.valueOf((Object)categoryScope) + "] [" + String.valueOf((Object)this.scope) + "] for category [" + String.valueOf(categoryDef) + "]");
        }
        N_CategoryKey key = new N_CategoryKey(categoryScope, schema, categoryDef.getHierarchyIndex(), categoryDef.getMemberIndex(), categoryDef.getCacheId());
        this.categories.put(key, new N_Category(categoryDef));
    }

    @Nullable
    public N_Category getCategory(N_Schema schema, int hierarchyIndex, int memberIndex, long cacheId) {
        N_CategoryKey key = new N_CategoryKey(this.scope, schema, hierarchyIndex, memberIndex, cacheId);
        N_Category category = this.categories.get(key);
        return category;
    }
}

