/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.cleaner.OlapFileCleaner;
import crazydev.iccube.cluster.node.backup.N_BackupManager;
import crazydev.iccube.cluster.node.context.N_AbstractContext;
import crazydev.iccube.cluster.node.context.N_ApplicationContext;
import crazydev.iccube.cluster.node.context.N_DefaultOlapContextLoggers;
import crazydev.iccube.cluster.node.context.N_MonitoringOlapContextLoggers;
import crazydev.iccube.cluster.node.context.N_OlapContext;
import crazydev.iccube.cluster.node.context.N_OlapContextLoggers;
import crazydev.iccube.cluster.node.engine.N_RequestStatusManager;
import crazydev.iccube.cluster.node.schema.N_BuildFactContext;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextRef;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextKind;
import crazydev.iccube.cluster.shared.schema.S_BuildSchemaContextRef;
import crazydev.iccube.cluster.shared.schema.S_HierarchyDimensionality;
import crazydev.iccube.cluster.shared.schema.S_HollowUpdate;
import crazydev.iccube.cluster.shared.schema.S_IncrLoadDimensionUpdateDef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.cluster.shared.schema.S_SchemaDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class N_BuildSchemaContext
extends N_AbstractContext
implements N_OlapContext {
    private final S_BuildSchemaContextRef ref;
    private final N_OlapContextLoggers loggers;
    private final S_BuildSchemaContextKind kind;
    private final N_Schema schema;
    @Nullable
    private final Object backup;
    @Nullable
    private final Object restore;
    private final OlapRuntimeContext runtimeContext;
    private final OlapBuilderContext builderContext;
    private final Map<S_BuildFactContextRef, N_BuildFactContext> factContexts = new ConcurrentHashMap<S_BuildFactContextRef, N_BuildFactContext>();

    public N_BuildSchemaContext(N_ApplicationContext appContext, S_BuildSchemaContextInitData data, @Nullable N_Schema schema) {
        super(appContext, data.getClientUUID());
        this.appContext = appContext;
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.kind = data.getKind();
        S_SchemaDef schemaDef = data.getSchemaDef();
        if (schema == null) {
            if (this.kind != S_BuildSchemaContextKind.FULL_LOAD) {
                throw new RuntimeException("internal error: inconsistent build schema [" + schemaDef.getName() + "] [" + String.valueOf((Object)this.kind) + "]");
            }
            this.schema = new N_Schema(appContext, schemaDef);
        } else {
            if (this.kind == S_BuildSchemaContextKind.FULL_LOAD) {
                throw new RuntimeException("internal error: inconsistent incr. load build schema [" + schemaDef.getName() + "]");
            }
            this.schema = schema;
        }
        this.backup = data.getBackup();
        this.restore = data.getRestore();
        this.runtimeContext = data.getRuntimeContext();
        this.builderContext = data.getBuilderContext();
        this.loggers = data.isMonitoring() ? N_MonitoringOlapContextLoggers.INSTANCE : N_DefaultOlapContextLoggers.INSTANCE;
    }

    public OlapEngineComponentConfiguration getConfiguration() {
        return this.appContext.getConfiguration();
    }

    public OlapRuntimeContext asRuntimeContext() {
        return this.runtimeContext;
    }

    public OlapBuilderContext asBuilderContext() {
        return this.builderContext;
    }

    @Override
    public N_OlapContextLoggers loggers() {
        return this.loggers;
    }

    public boolean isIncrLoad() {
        return this.kind == S_BuildSchemaContextKind.INCREMENTAL_LOAD;
    }

    public boolean isLoadPartitions() {
        return this.kind == S_BuildSchemaContextKind.PARTITION_LOAD;
    }

    public boolean isRestoring() {
        return this.restore != null;
    }

    @Override
    public void onProgressEvent(String messageTag, Serializable ... params) {
        N_RequestStatusManager statusManager = this.appContext.getRequestStatusManager();
        statusManager.onRequestProgress(this.clientUUID, messageTag, params);
    }

    @Override
    public void onProgressPhase(String messageTag, Serializable ... params) {
        N_RequestStatusManager statusManager = this.appContext.getRequestStatusManager();
        statusManager.onRequestProgressPhase(this.clientUUID, messageTag, params);
    }

    public OlapFileCleaner getFileCleaner() {
        return this.appContext.getFileCleaner();
    }

    public N_Schema getSchema() {
        return this.schema;
    }

    public String getSchemaName() {
        return this.schema.getName();
    }

    public S_SchemaRef getSchemaRef() {
        return this.schema.getSchemaRef();
    }

    public S_SchemaDef getSchemaDef() {
        return this.schema.getSchemaDef();
    }

    @Nullable
    public Object getBackup() {
        return this.backup;
    }

    public void createFactContext(S_BuildFactContextInitData data) {
        N_BuildFactContext buildFactContext;
        S_BuildFactContextRef buildFactContextRef = data.getRef();
        N_BuildFactContext prev = this.factContexts.put(buildFactContextRef, buildFactContext = new N_BuildFactContext(this, data));
        if (prev != null) {
            throw new RuntimeException("internal error: duplicated build fact schema [" + this.schema.getName() + "] context setup [" + String.valueOf(buildFactContextRef) + "] [" + String.valueOf(prev) + "]");
        }
    }

    public N_BuildFactContext resolveFactContext(S_BuildFactContextRef contextRef) {
        Object referenced = contextRef.getReferenced();
        if (referenced != null) {
            N_BuildFactContext buildFactContext = (N_BuildFactContext)referenced;
            return buildFactContext;
        }
        N_BuildFactContext factContext = this.factContexts.get(contextRef);
        if (factContext == null) {
            throw new RuntimeException("internal error: missing build fact schema [" + this.schema.getName() + "] context [" + String.valueOf(contextRef) + "]");
        }
        return factContext;
    }

    public void onDimensionChanged(S_IncrLoadDimensionUpdateDef incrLoadUpdate, S_HollowUpdate hollowUpdate) {
        this.schema.onDimensionChanged(this, incrLoadUpdate, hollowUpdate);
    }

    public void onTableRowsProcessingCompleted(S_MeasureGroupRef measureGroupRef, S_FactPageRef factPageRef) {
        this.schema.onTableRowsProcessingCompleted(this, measureGroupRef, factPageRef);
    }

    public void onProcessFactsCompleted(S_MeasureGroupRef measureGroupRef, S_HierarchyDimensionality indexingHierarchies) {
        this.schema.onProcessFactsCompleted(this, measureGroupRef, indexingHierarchies);
    }

    public void onIncrLoadProcessFactsCompleted(S_MeasureGroupRef measureGroupRef) {
        this.schema.onIncrLoadProcessFactsCompleted(this, measureGroupRef);
    }

    public void restoreFacts() {
        if (this.restore != null) {
            N_BackupManager backupManager = this.appContext.getBackupManager();
            backupManager.restoreFacts(this.restore, this.schema);
        }
    }

    public boolean isWithIncrementalLoad() {
        return this.builderContext.isIncrLoadActive();
    }
}

