/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.schema;

import crazydev.iccube.builder.model.builders.facts.tasks.N_FactPageBatchInfo;
import crazydev.iccube.cluster.node.schema.N_BuildSchemaContext;
import crazydev.iccube.cluster.node.schema.N_Schema;
import crazydev.iccube.cluster.shared.facts.S_FactPageRef;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextInitData;
import crazydev.iccube.cluster.shared.schema.S_BuildFactContextRef;
import crazydev.iccube.cluster.shared.schema.S_CubeRef;
import crazydev.iccube.cluster.shared.schema.S_MeasureGroupRef;
import crazydev.iccube.configuration.component.OlapEngineComponentConfiguration;
import crazydev.iccube.enums.OlapFactRowAggregationType;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.schema.stats.OlapSchemaFactsBuilderStats;
import org.jetbrains.annotations.Nullable;

public class N_BuildFactContext {
    @Nullable
    private final OlapSchemaFactsBuilderStats stats;
    private final N_BuildSchemaContext buildSchemaContext;
    private final S_BuildFactContextRef ref;
    private final S_CubeRef cubeRef;
    private final S_MeasureGroupRef measureGroupRef;
    private final OlapFactRowAggregationType rowAggregationType;

    public N_BuildFactContext(N_BuildSchemaContext buildSchemaContext, S_BuildFactContextInitData data) {
        this.stats = data.getFullLoadStats();
        this.buildSchemaContext = buildSchemaContext;
        this.ref = data.getRef();
        this.ref.setReferenced(this);
        this.cubeRef = data.getCubeRef();
        this.measureGroupRef = data.getMeasureGroupRef();
        this.rowAggregationType = data.getRowAggregationType();
    }

    public N_BuildSchemaContext getSchemaContext() {
        return this.buildSchemaContext;
    }

    public String getSchemaName() {
        return this.buildSchemaContext.getSchemaName();
    }

    public OlapEngineComponentConfiguration getConfiguration() {
        return this.buildSchemaContext.getConfiguration();
    }

    public OlapRuntimeContext asRuntimeContext() {
        return this.buildSchemaContext.asRuntimeContext();
    }

    public boolean isRestoring() {
        return this.buildSchemaContext.asBuilderContext().isRestoring();
    }

    public boolean isIncrLoad() {
        return this.buildSchemaContext.isIncrLoad();
    }

    public boolean isLoadPartitions() {
        return this.buildSchemaContext.isLoadPartitions();
    }

    public void createPartition(S_FactPageRef factPageRef, boolean empty, int backupID, String nameForStats) {
        N_Schema schema = this.buildSchemaContext.getSchema();
        schema.createFactPage(this, this.cubeRef, this.measureGroupRef, factPageRef, empty, backupID, nameForStats);
    }

    public void addFactRows(N_FactPageBatchInfo info) {
        info.addFactsRows(this.stats, this.buildSchemaContext, this, this.cubeRef, this.measureGroupRef, this.rowAggregationType);
    }
}

