/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.perms;

import crazydev.iccube.cluster.node.engine.N_CacheEventListener;
import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.node.perms.N_SecurityPermissionsKey;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmap;
import crazydev.iccube.olap.index.bitmap.facts.OlapFactsBitmapOne;
import crazydev.iccube.olap.index.bitmap.tor.OlapBitmapTor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class N_SecurityPermissionsManager
implements N_CacheEventListener {
    private final Map<N_SecurityPermissionsKey.RoleSchema, S_FactPermsDef> permsDefinitions = new ConcurrentHashMap<N_SecurityPermissionsKey.RoleSchema, S_FactPermsDef>();
    private final Map<N_SecurityPermissionsKey, OlapFactsBitmap> perms = new ConcurrentHashMap<N_SecurityPermissionsKey, OlapFactsBitmap>();

    @Override
    public void onSchemaLoadedDone(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaLoaded(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaLoadedOnError(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaIncrLoaded(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaIncrLoadedOnError(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaPartitionsUnloaded(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaPartitionsLoaded(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaPartitionsLoadedOnError(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaScriptStatementApplied(S_SchemaRef schemaRef) {
    }

    @Override
    public void onSchemaUnloaded(S_SchemaRef schemaRef) {
        this.removeAllPermissions(schemaRef);
    }

    @Override
    public void onSchemaSecurityAllPermissionsRemoved(S_SchemaRef schemaRef) {
        this.removeAllPermissions(schemaRef);
    }

    @Override
    public void onSchemaSecurityPermissionsSwitched(S_SchemaRef schemaRef, String roleName, S_FactPermsDef perms) {
        N_SecurityPermissionsKey.RoleSchema key = new N_SecurityPermissionsKey.RoleSchema(roleName, schemaRef);
        this.permsDefinitions.put(key, perms);
        this.perms.entrySet().removeIf(entry -> ((N_SecurityPermissionsKey)entry.getKey()).asRoleSchema().equals(key));
    }

    @Nullable
    public S_FactPermsDef getSchemaSecurityPermissions(String role, S_SchemaRef schemaRef) {
        N_SecurityPermissionsKey.RoleSchema key = new N_SecurityPermissionsKey.RoleSchema(role, schemaRef);
        S_FactPermsDef permsDef = this.permsDefinitions.get(key);
        return permsDef;
    }

    @Nullable
    public OlapFactsBitmap getOrCreateSchemaSecurityPermissions(String role, S_SchemaRef schemaRef, S_FactPermsDef permsDef, N_FactBitmapContainer bitmapContainer) {
        N_SecurityPermissionsKey key = new N_SecurityPermissionsKey(role, schemaRef, permsDef, bitmapContainer);
        OlapFactsBitmap bitmap = this.perms.get(key);
        if (bitmap == null) {
            bitmap = this.createPermissions(key);
        }
        return bitmap == OlapFactsBitmapOne.INSTANCE ? null : bitmap;
    }

    private void removeAllPermissions(S_SchemaRef schemaRef) {
        for (N_SecurityPermissionsKey.RoleSchema roleSchema : this.permsDefinitions.keySet()) {
            if (roleSchema.getSchemaRef() != schemaRef) continue;
            this.permsDefinitions.remove(roleSchema);
        }
        for (N_SecurityPermissionsKey n_SecurityPermissionsKey : this.perms.keySet()) {
            if (n_SecurityPermissionsKey.getSchemaRef() != schemaRef) continue;
            this.perms.remove(n_SecurityPermissionsKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OlapFactsBitmap createPermissions(N_SecurityPermissionsKey key) {
        Map<N_SecurityPermissionsKey, OlapFactsBitmap> map = this.perms;
        synchronized (map) {
            OlapFactsBitmap bitmap = this.perms.get(key);
            if (bitmap == null) {
                N_FactBitmapContainer bitmapContainer = key.getMeasureGroup();
                S_FactPermsDef permDef = key.getPermsDef();
                OlapBitmapTor tor = permDef.createBitmapTor(key.getRole(), bitmapContainer.getMeasureGroupDef(), bitmapContainer);
                bitmap = tor == null ? OlapFactsBitmapOne.INSTANCE : tor.solve();
                S_FactPermsDef currentPermsDef = this.permsDefinitions.get(key.asRoleSchema());
                if (currentPermsDef == permDef) {
                    this.perms.put(key, bitmap);
                }
            }
            return bitmap;
        }
    }
}

