/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.perms;

import crazydev.iccube.cluster.node.facts.N_FactBitmapContainer;
import crazydev.iccube.cluster.shared.perms.S_FactPermsDef;
import crazydev.iccube.cluster.shared.schema.S_SchemaRef;

public class N_SecurityPermissionsKey {
    private final String role;
    private final S_SchemaRef schemaRef;
    private final S_FactPermsDef permsDef;
    private final N_FactBitmapContainer measureGroup;

    public N_SecurityPermissionsKey(String role, S_SchemaRef schemaRef, S_FactPermsDef permsDef, N_FactBitmapContainer measureGroup) {
        this.role = role;
        this.schemaRef = schemaRef;
        this.permsDef = permsDef;
        this.measureGroup = measureGroup;
    }

    public String getRole() {
        return this.role;
    }

    public S_SchemaRef getSchemaRef() {
        return this.schemaRef;
    }

    public S_FactPermsDef getPermsDef() {
        return this.permsDef;
    }

    public N_FactBitmapContainer getMeasureGroup() {
        return this.measureGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        N_SecurityPermissionsKey that = (N_SecurityPermissionsKey)o;
        if (!this.role.equals(that.role)) {
            return false;
        }
        if (!this.schemaRef.equals(that.schemaRef)) {
            return false;
        }
        if (!this.permsDef.equals(that.permsDef)) {
            return false;
        }
        return this.measureGroup.equals(that.measureGroup);
    }

    public int hashCode() {
        int result = this.role.hashCode();
        result = 31 * result + this.schemaRef.hashCode();
        result = 31 * result + this.permsDef.hashCode();
        result = 31 * result + this.measureGroup.hashCode();
        return result;
    }

    public RoleSchema asRoleSchema() {
        return new RoleSchema(this.role, this.schemaRef);
    }

    public static class RoleSchema {
        private final String role;
        private final S_SchemaRef schemaRef;

        public RoleSchema(String role, S_SchemaRef schemaRef) {
            this.role = role;
            this.schemaRef = schemaRef;
        }

        public String getRole() {
            return this.role;
        }

        public S_SchemaRef getSchemaRef() {
            return this.schemaRef;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleSchema that = (RoleSchema)o;
            if (!this.role.equals(that.role)) {
                return false;
            }
            return this.schemaRef.equals(that.schemaRef);
        }

        public int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + this.schemaRef.hashCode();
            return result;
        }
    }
}

