/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.cluster.node.facts.sparse;

import crazydev.iccube.cluster.node.backup.N_RestoreContext;
import crazydev.iccube.cluster.node.facts.sparse.N_HashSparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_PaginatedSparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseList;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListBackupType;
import crazydev.iccube.cluster.node.facts.sparse.N_SparseListMutatedException;
import crazydev.iccube.cluster.shared.backup.S_BackupInputStream;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public abstract class N_SparseListBackupHelper {
    private N_SparseListBackupHelper() {
    }

    @Nullable
    public static N_SparseList restore(N_RestoreContext context, S_BackupInputStream in, String facts, String partition) throws IOException {
        int info = in.readInt();
        if (info < -1) {
            return N_SparseListBackupHelper.doRestore(context, in, info);
        }
        if (info == -1) {
            return null;
        }
        int sListSizeMax = info;
        N_SparseList slist = new N_PaginatedSparseList(sListSizeMax, 10);
        for (int mm = 0; mm < slist.getSizeMax(); ++mm) {
            if (context.isCancelling()) {
                return null;
            }
            int wordCount = in.readInt();
            if (wordCount <= -1) continue;
            int[] words = new int[wordCount];
            in.readInts(words);
            try {
                slist.set(mm, words);
                continue;
            }
            catch (N_SparseListMutatedException ex) {
                slist = ex.getTo();
            }
        }
        ((N_SparseList)slist).compact(context, true);
        N_SparseList optimized = ((N_SparseList)slist).optimize(context, facts, partition);
        return optimized;
    }

    private static N_SparseList doRestore(N_RestoreContext context, S_BackupInputStream in, int info) throws IOException {
        if (info == -2) {
            return null;
        }
        int backupType = -info - 3;
        N_SparseListBackupType type = N_SparseListBackupType.persistentValueOf(backupType);
        switch (type) {
            case PAGINATED: {
                return N_PaginatedSparseList.restore(context, in);
            }
            case HASH: {
                return N_HashSparseList.restore(context, in);
            }
        }
        throw new RuntimeException("internal error: unexpected sparse list backup type [" + String.valueOf((Object)type) + "]");
    }
}

